/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.support.yaml;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.springframework.cloud.skipper.support.yaml.YamlBuilder;
import org.springframework.cloud.skipper.support.yaml.YamlConversionResult;
import org.springframework.cloud.skipper.support.yaml.YamlConversionStatus;
import org.springframework.cloud.skipper.support.yaml.YamlConverter;
import org.springframework.cloud.skipper.support.yaml.YamlPath;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class DefaultYamlConverter
implements YamlConverter {
    private static final Pattern COMMENT = Pattern.compile("(?m)^\\s*(\\#|\\!)");
    private final YamlConversionStatus status = new YamlConversionStatus();
    private final YamlConverter.Mode mode;
    private final ArrayList<Map<String, String>> mapList;
    private final ArrayList<Properties> propertiesList;
    private final ArrayList<File> fileList;
    private final ArrayList<String> keyspaceList;

    public DefaultYamlConverter(YamlConverter.Mode mode, ArrayList<Map<String, String>> mapList, ArrayList<Properties> propertiesList, ArrayList<File> fileList, ArrayList<String> keyspaceList) {
        this.mode = mode != null ? mode : YamlConverter.Mode.DEFAULT;
        this.propertiesList = propertiesList;
        this.mapList = mapList;
        this.fileList = fileList;
        this.keyspaceList = keyspaceList;
    }

    @Override
    public YamlConversionResult convert() {
        HashMap<String, Collection<String>> propertiesMap = new HashMap<String, Collection<String>>();
        this.mapList.forEach((Consumer<Map<String, String>>)((Consumer<Map>)m -> this.addMap((Map<String, Collection<String>>)propertiesMap, (Map<String, String>)m)));
        this.propertiesList.forEach(p -> this.addProperties((Map<String, Collection<String>>)propertiesMap, (Properties)p));
        this.fileList.forEach(f -> this.addFile((Map<String, Collection<String>>)propertiesMap, (File)f));
        return this.convert(propertiesMap);
    }

    private Map<String, Collection<String>> addFile(Map<String, Collection<String>> propertiesMap, File file) {
        Properties p = new Properties();
        try {
            String content = new String(Files.readAllBytes(Paths.get(file.toURI())));
            if (this.hasComments(content)) {
                this.status.addWarning("The properties file has comments, which will be lost in the refactoring!");
            }
            p.load(new StringReader(content));
        }
        catch (IOException e) {
            this.status.addError("Problem loading file " + file + ": " + e.getMessage());
        }
        return this.addProperties(propertiesMap, p);
    }

    private Map<String, Collection<String>> addProperties(Map<String, Collection<String>> propertiesMap, Properties properties) {
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            LinkedHashSet<String> s = new LinkedHashSet<String>();
            s.add((String)e.getValue());
            propertiesMap.put((String)e.getKey(), s);
        }
        return propertiesMap;
    }

    private Map<String, Collection<String>> addMap(Map<String, Collection<String>> propertiesMap, Map<String, String> properties) {
        for (Map.Entry<String, String> e : properties.entrySet()) {
            LinkedHashSet<String> s = new LinkedHashSet<String>();
            s.add(e.getValue());
            propertiesMap.put(e.getKey(), s);
        }
        return propertiesMap;
    }

    private YamlConversionResult convert(Map<String, Collection<String>> properties) {
        if (properties.isEmpty()) {
            return YamlConversionResult.EMPTY;
        }
        YamlBuilder root = new YamlBuilder(this.mode, this.keyspaceList, this.status, YamlPath.EMPTY);
        for (Map.Entry<String, Collection<String>> e : properties.entrySet()) {
            for (String v : e.getValue()) {
                root.addProperty(YamlPath.fromProperty(e.getKey()), v);
            }
        }
        Object object = root.build();
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(options), options);
        String output = yaml.dump(object);
        return new YamlConversionResult(this.status, output);
    }

    private boolean hasComments(String line) {
        return COMMENT.matcher(line).find();
    }

    public static class DefaultBuilder
    implements YamlConverter.Builder {
        private YamlConverter.Mode mode;
        private ArrayList<Properties> propertiesList = new ArrayList();
        private ArrayList<Map<String, String>> mapList = new ArrayList();
        private ArrayList<File> fileList = new ArrayList();
        private ArrayList<String> keyspaceList = new ArrayList();

        @Override
        public YamlConverter.Builder mode(YamlConverter.Mode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public YamlConverter.Builder flat(String keyspace) {
            this.keyspaceList.add(keyspace);
            return this;
        }

        @Override
        public YamlConverter.Builder file(File file) {
            this.fileList.add(file);
            return this;
        }

        @Override
        public YamlConverter.Builder properties(Properties properties) {
            this.propertiesList.add(properties);
            return this;
        }

        @Override
        public YamlConverter.Builder map(Map<String, String> properties) {
            this.mapList.add(properties);
            return this;
        }

        @Override
        public YamlConverter build() {
            return new DefaultYamlConverter(this.mode, this.mapList, this.propertiesList, this.fileList, this.keyspaceList);
        }
    }
}

