/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScaleRequest {
    private List<ScaleRequestItem> scale = new ArrayList<ScaleRequestItem>();

    public ScaleRequest() {
    }

    public ScaleRequest(List<ScaleRequestItem> scale) {
        if (scale != null) {
            this.scale = scale;
        }
    }

    public List<ScaleRequestItem> getScale() {
        return this.scale;
    }

    public void setScale(List<ScaleRequestItem> scale) {
        this.scale = scale;
    }

    public static ScaleRequest of(String name, Integer count) {
        return new ScaleRequest(Arrays.asList(new ScaleRequestItem(name, count, null)));
    }

    public static ScaleRequest of(String name, Integer count, Map<String, String> properties) {
        return new ScaleRequest(Arrays.asList(new ScaleRequestItem(name, count, properties)));
    }

    public String toString() {
        return this.scale != null ? this.scale.toString() : super.toString();
    }

    public static class ScaleRequestItem {
        private String name;
        private Integer count;
        private Map<String, String> properties = new HashMap<String, String>();

        public ScaleRequestItem() {
        }

        public ScaleRequestItem(String name, Integer count) {
            this(name, count, null);
        }

        public ScaleRequestItem(String name, Integer count, Map<String, String> properties) {
            this.name = name;
            this.count = count;
            if (properties != null) {
                this.properties = properties;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public String toString() {
            return "ScaleRequest [appName= " + this.name + ", count= " + this.count + ", properties= " + this.properties.toString() + "]";
        }
    }
}

