/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.support.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.springframework.cloud.skipper.support.yaml.YamlPathSegment;

class YamlPath {
    public static final YamlPath EMPTY = new YamlPath();
    private final YamlPathSegment[] segments;

    YamlPath() {
        this.segments = new YamlPathSegment[0];
    }

    YamlPath(List<YamlPathSegment> segments) {
        this.segments = segments.toArray(new YamlPathSegment[segments.size()]);
    }

    YamlPath(YamlPathSegment ... segments) {
        this.segments = segments;
    }

    public String toPropString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (YamlPathSegment s : this.segments) {
            if (first) {
                buf.append(s.toPropString());
            } else {
                buf.append(s.toNavString());
            }
            first = false;
        }
        return buf.toString();
    }

    public String toNavString() {
        StringBuilder buf = new StringBuilder();
        for (YamlPathSegment s : this.segments) {
            buf.append(s.toNavString());
        }
        return buf.toString();
    }

    public YamlPathSegment[] getSegments() {
        return this.segments;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static YamlPath fromProperty(String propName) {
        ArrayList<YamlPathSegment> segments = new ArrayList<YamlPathSegment>();
        String delim = ".[]";
        StringTokenizer tokens = new StringTokenizer(propName, delim, true);
        try {
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken(delim);
                if (token.equals(".") || token.equals("]")) continue;
                if (token.equals("[")) {
                    String bracketed = tokens.nextToken("]");
                    if (bracketed.equals("]")) continue;
                    try {
                        int index = Integer.parseInt(bracketed);
                        segments.add(YamlPathSegment.valueAt(index));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        segments.add(YamlPathSegment.valueAt(bracketed));
                        continue;
                    }
                }
                segments.add(YamlPathSegment.valueAt(token));
            }
            return new YamlPath(segments);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new YamlPath(segments);
    }

    public static YamlPath fromSimpleProperty(String name) {
        return new YamlPath(YamlPathSegment.valueAt(name));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("YamlPath(");
        boolean first = true;
        for (YamlPathSegment s : this.segments) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(s);
            first = false;
        }
        buf.append(")");
        return buf.toString();
    }

    public int size() {
        return this.segments.length;
    }

    public YamlPathSegment getSegment(int segment) {
        if (segment >= 0 && segment < this.segments.length) {
            return this.segments[segment];
        }
        return null;
    }

    public YamlPath prepend(YamlPathSegment s) {
        YamlPathSegment[] newPath = new YamlPathSegment[this.segments.length + 1];
        newPath[0] = s;
        System.arraycopy(this.segments, 0, newPath, 1, this.segments.length);
        return new YamlPath(newPath);
    }

    public YamlPath append(YamlPathSegment s) {
        YamlPathSegment[] newPath = Arrays.copyOf(this.segments, this.segments.length + 1);
        newPath[this.segments.length] = s;
        return new YamlPath(newPath);
    }

    public YamlPath dropFirst(int dropCount) {
        if (dropCount >= this.size()) {
            return EMPTY;
        }
        if (dropCount == 0) {
            return this;
        }
        YamlPathSegment[] newPath = new YamlPathSegment[this.segments.length - dropCount];
        for (int i = 0; i < newPath.length; ++i) {
            newPath[i] = this.segments[i + dropCount];
        }
        return new YamlPath(newPath);
    }

    public YamlPath dropLast() {
        return this.dropLast(1);
    }

    public YamlPath dropLast(int dropCount) {
        if (dropCount >= this.size()) {
            return EMPTY;
        }
        if (dropCount == 0) {
            return this;
        }
        YamlPathSegment[] newPath = new YamlPathSegment[this.segments.length - dropCount];
        for (int i = 0; i < newPath.length; ++i) {
            newPath[i] = this.segments[i];
        }
        return new YamlPath(newPath);
    }

    public boolean isEmpty() {
        return this.segments.length == 0;
    }

    public YamlPath tail() {
        return this.dropFirst(1);
    }

    public YamlPathSegment getLastSegment() {
        if (!this.isEmpty()) {
            return this.segments[this.segments.length - 1];
        }
        return null;
    }
}

