/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import org.springframework.lang.Nullable;

public interface SamplerFunction<T> {
    @Nullable
    public Boolean trySample(@Nullable T var1);

    public static <T> SamplerFunction<T> deferDecision() {
        return Constants.DEFER_DECISION;
    }

    public static <T> SamplerFunction<T> neverSample() {
        return Constants.NEVER_SAMPLE;
    }

    public static <T> SamplerFunction<T> alwaysSample() {
        return Constants.ALWAYS_SAMPLE;
    }

    public static enum Constants implements SamplerFunction<Object>
    {
        DEFER_DECISION{

            @Override
            public Boolean trySample(Object request) {
                return null;
            }

            public String toString() {
                return "DeferDecision";
            }
        }
        ,
        NEVER_SAMPLE{

            @Override
            public Boolean trySample(Object request) {
                return false;
            }

            public String toString() {
                return "NeverSample";
            }
        }
        ,
        ALWAYS_SAMPLE{

            @Override
            public Boolean trySample(Object request) {
                return true;
            }

            public String toString() {
                return "AlwaysSample";
            }
        };

    }
}

