/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.exporter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.exporter.SpanFilter;
import org.springframework.util.StringUtils;

public class SpanIgnoringSpanFilter
implements SpanFilter {
    private static final Log log = LogFactory.getLog(SpanIgnoringSpanFilter.class);
    private final List<String> spanNamePatternsToSkip;
    private final List<String> additionalSpanNamePatternsToIgnore;
    static final Map<String, Pattern> cache = new ConcurrentHashMap<String, Pattern>();

    public SpanIgnoringSpanFilter(List<String> spanNamePatternsToSkip, List<String> additionalSpanNamePatternsToIgnore) {
        this.spanNamePatternsToSkip = spanNamePatternsToSkip;
        this.additionalSpanNamePatternsToIgnore = additionalSpanNamePatternsToIgnore;
    }

    private List<Pattern> spanNamesToIgnore() {
        return this.spanNames().stream().map(regex -> cache.computeIfAbsent((String)regex, Pattern::compile)).collect(Collectors.toList());
    }

    private List<String> spanNames() {
        ArrayList<String> spanNamesToIgnore = new ArrayList<String>(this.spanNamePatternsToSkip);
        spanNamesToIgnore.addAll(this.additionalSpanNamePatternsToIgnore);
        return spanNamesToIgnore;
    }

    @Override
    public boolean isExportable(FinishedSpan span) {
        List<Pattern> spanNamesToIgnore = this.spanNamesToIgnore();
        String name = span.getName();
        if (StringUtils.hasText((String)name) && spanNamesToIgnore.stream().anyMatch(p -> p.matcher(name).matches())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will ignore a span with name [" + name + "]"));
            }
            return false;
        }
        return true;
    }
}

