/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.async;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.async.TraceAsyncDefaultAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceAsyncCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AsyncConfigurer.class})
@ConditionalOnBean(value={AsyncConfigurer.class})
@AutoConfigureBefore(value={TraceAsyncDefaultAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.async.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.cloud.sleuth.instrument.scheduling.TraceSchedulingAutoConfiguration"}, value={BraveAutoConfiguration.class})
public class TraceAsyncCustomAutoConfiguration
implements BeanPostProcessor {
    @Autowired
    private BeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AsyncConfigurer && !(bean instanceof LazyTraceAsyncCustomizer)) {
            AsyncConfigurer configurer = (AsyncConfigurer)bean;
            return new LazyTraceAsyncCustomizer(this.beanFactory, configurer);
        }
        return bean;
    }
}

