/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.redis;

import io.lettuce.core.tracing.Tracing;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.redis.TraceRedisProperties;
import org.springframework.cloud.sleuth.instrument.redis.TraceLettuceClientResourcesBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.redis.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={Tracing.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceRedisProperties.class})
public class TraceRedisAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.redis.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    static class LettuceConfiguration {
        LettuceConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={Tracing.class})
        TraceLettuceClientResourcesBuilderCustomizer traceLettuceClientResourcesBuilderCustomizer(Tracing tracing) {
            return new TraceLettuceClientResourcesBuilderCustomizer(tracing);
        }
    }
}

