/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinBraveConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderConfigurationImportSelector;
import org.springframework.cloud.sleuth.zipkin2.DefaultEndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.DefaultZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;
import zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ZipkinProperties.class})
@ConditionalOnClass(value={Sender.class, EndpointLocator.class})
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.zipkin.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.cloud.autoconfigure.RefreshAutoConfiguration", "org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration", "org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration"})
@AutoConfigureBefore(value={BraveAutoConfiguration.class})
@Import(value={ZipkinSenderConfigurationImportSelector.class, ZipkinBraveConfiguration.class})
public class ZipkinAutoConfiguration {
    private final ExecutorService zipkinExecutor = Executors.newSingleThreadExecutor();
    public static final String REPORTER_BEAN_NAME = "zipkinReporter";
    public static final String SENDER_BEAN_NAME = "zipkinSender";
    private static final Log log = LogFactory.getLog(ZipkinAutoConfiguration.class);

    static CompletableFuture<CheckResult> checkResult(ExecutorService zipkinExecutor, Sender sender, long deadlineMillis) {
        return CompletableFuture.supplyAsync(() -> ((Sender)sender).check(), zipkinExecutor).whenComplete((checkResult, throwable) -> {
            CheckResult result;
            Throwable exception;
            Throwable throwable2 = exception = throwable instanceof TimeoutException ? new TimeoutException("Timed out after " + deadlineMillis + "ms") : throwable;
            if (checkResult != null && checkResult.error() != null && checkResult.error().getCause() instanceof TimeoutException) {
                exception = new TimeoutException("Timed out after " + deadlineMillis + "ms");
                result = CheckResult.failed((Throwable)exception);
            } else {
                result = checkResult == null ? CheckResult.failed((Throwable)exception) : checkResult;
            }
            ZipkinAutoConfiguration.logCheckResult(sender, result);
            zipkinExecutor.shutdown();
        });
    }

    @Bean(value={"zipkinReporter"})
    @ConditionalOnMissingBean(name={"zipkinReporter"})
    Reporter<Span> reporter(ReporterMetrics reporterMetrics, final ZipkinProperties zipkin, @Qualifier(value="zipkinSender") Sender sender) {
        ZipkinAutoConfiguration.checkResult(this.zipkinExecutor, sender, zipkin.getCheckTimeout());
        final AsyncReporter asyncReporter = AsyncReporter.builder((Sender)sender).queuedMaxSpans(zipkin.getQueuedMaxSpans()).messageTimeout((long)zipkin.getMessageTimeout(), TimeUnit.SECONDS).metrics(reporterMetrics).build((BytesEncoder)zipkin.getEncoder());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info((Object)"Flushing remaining spans on shutdown");
                asyncReporter.flush();
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(zipkin.getMessageTimeout()) + 500L);
                    log.debug((Object)"Flushing done - closing the reporter");
                    asyncReporter.close();
                }
                catch (ClosedSenderException ex) {
                    log.debug((Object)"Sender already closed", (Throwable)ex);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        return asyncReporter;
    }

    private static void logCheckResult(Sender sender, CheckResult checkResult) {
        if (log.isDebugEnabled() && checkResult != null && checkResult.ok()) {
            log.debug((Object)("Check result of the [" + sender.toString() + "] is [" + checkResult + "]"));
        } else if (checkResult != null && !checkResult.ok()) {
            log.warn((Object)("Check result of the [" + sender.toString() + "] contains an error [" + checkResult + "]"));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    ZipkinRestTemplateCustomizer zipkinRestTemplateCustomizer(ZipkinProperties zipkinProperties) {
        return new DefaultZipkinRestTemplateCustomizer(zipkinProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    ReporterMetrics sleuthReporterMetrics() {
        return new InMemoryReporterMetrics();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    static class TraceMetricsMicrometerConfiguration {
        TraceMetricsMicrometerConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={ReporterMetrics.class})
        static class NoReporterMetricsBeanConfiguration {
            NoReporterMetricsBeanConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={MeterRegistry.class})
            @ConditionalOnClass(name={"zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics"})
            ReporterMetrics sleuthMicrometerReporterMetrics(ObjectProvider<MeterRegistry> meterRegistry) {
                return new LazyMicrometerReporterMetrics(meterRegistry);
            }

            @Bean
            @ConditionalOnMissingClass(value={"zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics"})
            ReporterMetrics sleuthReporterMetrics() {
                return new InMemoryReporterMetrics();
            }

            static class LazyMicrometerReporterMetrics
            implements ReporterMetrics {
                private final ObjectProvider<MeterRegistry> objectProvider;
                private ReporterMetrics micrometerReporterMetrics;

                LazyMicrometerReporterMetrics(ObjectProvider<MeterRegistry> objectProvider) {
                    this.objectProvider = objectProvider;
                }

                private ReporterMetrics reporterMetrics() {
                    if (this.micrometerReporterMetrics == null) {
                        this.micrometerReporterMetrics = MicrometerReporterMetrics.create((MeterRegistry)((MeterRegistry)this.objectProvider.getObject()));
                    }
                    return this.micrometerReporterMetrics;
                }

                public void incrementMessages() {
                    this.reporterMetrics().incrementMessages();
                }

                public void incrementMessagesDropped(Throwable throwable) {
                    this.reporterMetrics().incrementMessagesDropped(throwable);
                }

                public void incrementSpans(int i) {
                    this.reporterMetrics().incrementSpans(i);
                }

                public void incrementSpanBytes(int i) {
                    this.reporterMetrics().incrementSpanBytes(i);
                }

                public void incrementMessageBytes(int i) {
                    this.reporterMetrics().incrementMessageBytes(i);
                }

                public void incrementSpansDropped(int i) {
                    this.reporterMetrics().incrementSpansDropped(i);
                }

                public void updateQueuedSpans(int i) {
                    this.reporterMetrics().updateQueuedSpans(i);
                }

                public void updateQueuedBytes(int i) {
                    this.reporterMetrics().updateQueuedBytes(i);
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.core.instrument.MeterRegistry"})
    static class TraceMetricsInMemoryConfiguration {
        TraceMetricsInMemoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReporterMetrics sleuthReporterMetrics() {
            return new InMemoryReporterMetrics();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Registration.class})
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="true")
    protected static class RegistrationEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Autowired
        private Environment environment;
        @Autowired(required=false)
        private Registration registration;

        protected RegistrationEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new DefaultEndpointLocator(this.registration, this.serverProperties, this.environment, this.zipkinProperties, this.inetUtils);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="false", matchIfMissing=true)
    protected static class DefaultEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Autowired
        private Environment environment;

        protected DefaultEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new DefaultEndpointLocator(null, this.serverProperties, this.environment, this.zipkinProperties, this.inetUtils);
        }
    }
}

