/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Valve;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.ConditionalOnSleuthWeb;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.TraceWebMvcConfigurer;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAspect;
import org.springframework.cloud.sleuth.instrument.web.mvc.SpanCustomizingAsyncHandlerInterceptor;
import org.springframework.cloud.sleuth.instrument.web.servlet.TracingFilter;
import org.springframework.cloud.sleuth.instrument.web.tomcat.TraceValve;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSleuthWeb
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={HandlerInterceptorAdapter.class})
@Import(value={SpanCustomizingAsyncHandlerInterceptor.class})
@ConditionalOnProperty(value={"spring.sleuth.web.servlet.enabled"}, matchIfMissing=true)
class TraceWebServletConfiguration {
    TraceWebServletConfiguration() {
    }

    @Bean
    TraceWebAspect traceWebAspect(Tracer tracer, CurrentTraceContext currentTraceContext, SpanNamer spanNamer) {
        return new TraceWebAspect(tracer, currentTraceContext, spanNamer);
    }

    @Bean
    FilterRegistrationBean traceWebFilter(BeanFactory beanFactory, SleuthWebProperties webProperties) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new LazyTracingFilter(beanFactory), new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(webProperties.getFilterOrder());
        return filterRegistrationBean;
    }

    static final class LazyTracingFilter
    implements Filter {
        private final BeanFactory beanFactory;
        private Filter tracingFilter;

        LazyTracingFilter(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            this.tracingFilter().init(filterConfig);
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.tracingFilter().doFilter(request, response, chain);
        }

        public void destroy() {
            this.tracingFilter().destroy();
        }

        private Filter tracingFilter() {
            if (this.tracingFilter == null) {
                this.tracingFilter = TracingFilter.create((CurrentTraceContext)((CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class)), (HttpServerHandler)((HttpServerHandler)this.beanFactory.getBean(HttpServerHandler.class)));
            }
            return this.tracingFilter;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Valve.class, ConfigurableTomcatWebServerFactory.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.tomcat.enabled"}, matchIfMissing=true)
    protected static class TraceTomcatConfiguration {
        static final String CUSTOMIZER_NAME = "traceTomcatWebServerFactoryCustomizer";

        protected TraceTomcatConfiguration() {
        }

        @Bean(name={"traceTomcatWebServerFactoryCustomizer"})
        @Order(value=-2147483648)
        WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory> traceTomcatWebServerFactoryCustomizer(ObjectProvider<HttpServerHandler> httpServerHandler, ObjectProvider<CurrentTraceContext> currentTraceContext) {
            return factory -> factory.addEngineValves(new Valve[]{new TraceValve(httpServerHandler, currentTraceContext)});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    @Import(value={TraceWebMvcConfigurer.class})
    protected static class TraceWebMvcAutoConfiguration {
        protected TraceWebMvcAutoConfiguration() {
        }
    }
}

