/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.brave.instrument.messaging.TraceConsumerPostProcessor;
import org.springframework.cloud.sleuth.brave.instrument.messaging.TraceProducerPostProcessor;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.ProducerFactory;

public class KafkaFactoryBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    public KafkaFactoryBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ProducerFactory factory;
        if (bean instanceof ConsumerFactory) {
            ConsumerFactory factory2 = (ConsumerFactory)bean;
            if (factory2.getPostProcessors().stream().noneMatch(o -> o instanceof TraceConsumerPostProcessor)) {
                factory2.addPostProcessor(new TraceConsumerPostProcessor(this.beanFactory));
            }
        } else if (bean instanceof ProducerFactory && (factory = (ProducerFactory)bean).getPostProcessors().stream().noneMatch(o -> o instanceof TraceProducerPostProcessor)) {
            factory.addPostProcessor(new TraceProducerPostProcessor(this.beanFactory));
        }
        return bean;
    }
}

