/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.jms.JmsTracing;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import org.springframework.beans.factory.BeanFactory;

class LazyXAConnectionFactory
implements XAConnectionFactory {
    private final BeanFactory beanFactory;
    private final XAConnectionFactory delegate;
    private JmsTracing jmsTracing;
    private XAConnectionFactory wrappedDelegate;

    LazyXAConnectionFactory(BeanFactory beanFactory, XAConnectionFactory delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.wrappedDelegate().createXAConnection();
    }

    public XAConnection createXAConnection(String s, String s1) throws JMSException {
        return this.wrappedDelegate().createXAConnection(s, s1);
    }

    public XAJMSContext createXAContext() {
        return this.wrappedDelegate().createXAContext();
    }

    public XAJMSContext createXAContext(String s, String s1) {
        return this.wrappedDelegate().createXAContext(s, s1);
    }

    private JmsTracing jmsTracing() {
        if (this.jmsTracing != null) {
            return this.jmsTracing;
        }
        this.jmsTracing = (JmsTracing)this.beanFactory.getBean(JmsTracing.class);
        return this.jmsTracing;
    }

    private XAConnectionFactory wrappedDelegate() {
        if (this.wrappedDelegate != null) {
            return this.wrappedDelegate;
        }
        this.wrappedDelegate = this.jmsTracing().xaConnectionFactory(this.delegate);
        return this.wrappedDelegate;
    }
}

