/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;

public class TraceRunnable
implements Runnable {
    private static final String DEFAULT_SPAN_NAME = "async";
    private final Tracer tracer;
    private final SpanNamer spanNamer;
    private final Runnable delegate;
    private final String name;
    private final Span parent;

    public TraceRunnable(Tracer tracer, SpanNamer spanNamer, Runnable delegate) {
        this(tracer, spanNamer, delegate, null);
    }

    public TraceRunnable(Tracer tracer, SpanNamer spanNamer, Runnable delegate, String name) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
        this.delegate = delegate;
        this.name = name;
        this.parent = tracer.getCurrentSpan();
    }

    @Override
    public void run() {
        Span span = this.startSpan();
        try {
            this.getDelegate().run();
        }
        finally {
            this.close(span);
        }
    }

    protected Span startSpan() {
        return this.tracer.createSpan(this.getSpanName(), this.parent);
    }

    protected String getSpanName() {
        if (this.name != null) {
            return this.name;
        }
        return this.spanNamer.name(this.delegate, DEFAULT_SPAN_NAME);
    }

    protected void close(Span span) {
        this.tracer.close(span);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public Runnable getDelegate() {
        return this.delegate;
    }

    public String getName() {
        return this.name;
    }

    public Span getParent() {
        return this.parent;
    }
}

