/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignResponseHeadersHolder;
import org.springframework.util.StringUtils;

class FeignResponseHeadersInjector
implements SpanInjector<FeignResponseHeadersHolder> {
    FeignResponseHeadersInjector() {
    }

    @Override
    public void inject(Span span, FeignResponseHeadersHolder carrier) {
        Map<String, Collection<String>> headers = carrier.responseHeaders;
        this.headersWithTraceId(span, headers);
    }

    private Map<String, Collection<String>> headersWithTraceId(Span span, Map<String, Collection<String>> headers) {
        HashMap<String, Collection<String>> newHeaders = new HashMap<String, Collection<String>>();
        newHeaders.putAll(headers);
        if (span == null) {
            this.setHeader(newHeaders, "X-B3-Sampled", "0");
            return newHeaders;
        }
        this.setHeader(newHeaders, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setHeader(newHeaders, "X-B3-TraceId", span.getTraceId());
        this.setHeader(newHeaders, "X-B3-SpanId", span.getSpanId());
        return newHeaders;
    }

    void setHeader(Map<String, Collection<String>> headers, String name, String value) {
        if (StringUtils.hasText((String)value) && !headers.containsKey(name)) {
            headers.put(name, Collections.singletonList(value));
        }
    }

    void setHeader(Map<String, Collection<String>> headers, String name, Long value) {
        if (value != null) {
            this.setHeader(headers, name, Span.idToHex(value));
        }
    }
}

