/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.net.URI;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignRequestContext;

final class TraceFeignRequestInterceptor
implements RequestInterceptor {
    private final Tracer tracer;
    private final SpanInjector<RequestTemplate> spanInjector;
    private final FeignRequestContext feignRequestContext = FeignRequestContext.getInstance();

    TraceFeignRequestInterceptor(Tracer tracer, SpanInjector<RequestTemplate> spanInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
    }

    public void apply(RequestTemplate template) {
        String spanName = this.getSpanName(template);
        Span span = this.getSpan(spanName);
        this.spanInjector.inject(span, template);
        span.logEvent("cs");
    }

    protected String getSpanName(RequestTemplate template) {
        URI uri = URI.create(template.url());
        return this.uriScheme(uri) + ":" + uri.getPath();
    }

    protected Span getSpan(String spanName) {
        if (!this.feignRequestContext.hasSpanInProcess()) {
            Span span = this.tracer.createSpan(spanName);
            this.feignRequestContext.putSpan(span, false);
            return span;
        }
        if (this.feignRequestContext.wasSpanRetried()) {
            return this.tracer.continueSpan(this.feignRequestContext.getCurrentSpan());
        }
        return this.tracer.createSpan(spanName);
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }
}

