/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.zuul.ZuulFilter;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

public class TracePostZuulFilter
extends ZuulFilter {
    private final Tracer tracer;

    public TracePostZuulFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    public boolean shouldFilter() {
        return this.getCurrentSpan() != null;
    }

    public Object run() {
        this.getCurrentSpan().logEvent("cr");
        this.tracer.close(this.getCurrentSpan());
        return null;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }

    private Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }
}

