/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.ZuulFilterResult;
import com.netflix.zuul.context.RequestContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;

public class TracePreZuulFilter
extends ZuulFilter {
    private static final String ZUUL_COMPONENT = "zuul";
    private final Tracer tracer;
    private final SpanInjector<RequestContext> spanInjector;

    public TracePreZuulFilter(Tracer tracer, SpanInjector<RequestContext> spanInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        this.getCurrentSpan().logEvent("cs");
        return null;
    }

    public ZuulFilterResult runFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        Span span = this.getCurrentSpan();
        Span newSpan = this.tracer.createSpan(span.getName(), span);
        newSpan.tag("lc", ZUUL_COMPONENT);
        this.spanInjector.inject(newSpan, ctx);
        ZuulFilterResult result = super.runFilter();
        if (ExecutionStatus.SUCCESS != result.getStatus()) {
            this.tracer.close(newSpan);
        }
        return result;
    }

    private Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }
}

