/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import java.util.Random;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.NoOpSpanReporter;
import org.springframework.cloud.sleuth.Sampler;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.log.SpanLogger;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.cloud.sleuth.trace.DefaultTracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TraceKeys.class})
public class TraceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Random randomForSpanIds() {
        return new Random();
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler defaultTraceSampler() {
        return NeverSampler.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean(value={Tracer.class})
    public DefaultTracer sleuthTracer(Sampler sampler, Random random, SpanNamer spanNamer, SpanLogger spanLogger, SpanReporter spanReporter) {
        return new DefaultTracer(sampler, random, spanNamer, spanLogger, spanReporter);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpanNamer spanNamer() {
        return new DefaultSpanNamer();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpanReporter defaultSpanReporter() {
        return new NoOpSpanReporter();
    }
}

