/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.AsyncCustomAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.cloud.sleuth.instrument.async.TraceAsyncAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
@ConditionalOnProperty(value={"spring.sleuth.async.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={AsyncCustomAutoConfiguration.class})
public class AsyncDefaultAutoConfiguration {
    @Bean
    public TraceAsyncAspect traceAsyncAspect(Tracer tracer, TraceKeys traceKeys) {
        return new TraceAsyncAspect(tracer, traceKeys);
    }

    @Configuration
    @ConditionalOnMissingBean(value={AsyncConfigurer.class})
    @ConditionalOnProperty(value={"spring.sleuth.async.configurer.enabled"}, matchIfMissing=true)
    static class DefaultAsyncConfigurerSupport
    extends AsyncConfigurerSupport {
        @Autowired
        private BeanFactory beanFactory;

        DefaultAsyncConfigurerSupport() {
        }

        public Executor getAsyncExecutor() {
            return new LazyTraceExecutor(this.beanFactory, (Executor)new SimpleAsyncTaskExecutor());
        }
    }
}

