/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.ClassUtils;

abstract class AbstractTraceChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    protected static final String MESSAGE_COMPONENT = "message";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final SpanExtractor<Message<?>> spanExtractor;
    private final SpanInjector<MessageBuilder<?>> spanInjector;

    protected AbstractTraceChannelInterceptor(Tracer tracer, TraceKeys traceKeys, SpanExtractor<Message<?>> spanExtractor, SpanInjector<MessageBuilder<?>> spanInjector) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.spanExtractor = spanExtractor;
        this.spanInjector = spanInjector;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected TraceKeys getTraceKeys() {
        return this.traceKeys;
    }

    protected SpanInjector<MessageBuilder<?>> getSpanInjector() {
        return this.spanInjector;
    }

    protected Span buildSpan(Message<?> message) {
        return this.spanExtractor.joinTrace(message);
    }

    String getChannelName(MessageChannel channel) {
        String name = null;
        if (ClassUtils.isPresent((String)"org.springframework.integration.context.IntegrationObjectSupport", null)) {
            if (channel instanceof IntegrationObjectSupport) {
                name = ((IntegrationObjectSupport)channel).getComponentName();
            }
            if (name == null && channel instanceof AbstractMessageChannel) {
                name = ((AbstractMessageChannel)channel).getFullChannelName();
            }
        }
        if (name == null) {
            name = channel.toString();
        }
        return name;
    }

    String getMessageChannelName(MessageChannel channel) {
        return "message:" + this.getChannelName(channel);
    }
}

