/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.StringUtils;

class MessagingSpanInjector
implements SpanInjector<MessageBuilder<?>> {
    public static final String SPAN_HEADER = "X-Current-Span";
    private final TraceKeys traceKeys;

    public MessagingSpanInjector(TraceKeys traceKeys) {
        this.traceKeys = traceKeys;
    }

    @Override
    public void inject(Span span, MessageBuilder<?> carrier) {
        Message initialMessage = carrier.build();
        MessageHeaderAccessor accessor = MessageHeaderAccessor.getMutableAccessor((Message)initialMessage);
        if (span == null) {
            if (!"1".equals(initialMessage.getHeaders().get((Object)"X-B3-Sampled"))) {
                accessor.setHeader("X-B3-Sampled", (Object)"0");
                carrier.setHeaders(accessor);
                return;
            }
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.addHeader(headers, "X-B3-TraceId", Span.idToHex(span.getTraceId()));
        this.addHeader(headers, "X-B3-SpanId", Span.idToHex(span.getSpanId()));
        if (span.isExportable()) {
            this.addAnnotations(this.traceKeys, initialMessage, span);
            Long parentId = this.getFirst(span.getParents());
            if (parentId != null) {
                this.addHeader(headers, "X-B3-ParentSpanId", Span.idToHex(parentId));
            }
            this.addHeader(headers, "X-Span-Name", span.getName());
            this.addHeader(headers, "X-Process-Id", span.getProcessId());
            this.addHeader(headers, "X-B3-Sampled", "1");
        } else {
            this.addHeader(headers, "X-B3-Sampled", "0");
        }
        accessor.setHeader(SPAN_HEADER, (Object)span);
        accessor.copyHeaders(headers);
        if (accessor instanceof NativeMessageHeaderAccessor) {
            NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
            for (String name : headers.keySet()) {
                nativeAccessor.setNativeHeader(name, (String)headers.get(name));
            }
        }
        carrier.setHeaders(accessor);
    }

    private void addAnnotations(TraceKeys traceKeys, Message<?> message, Span span) {
        for (String name : traceKeys.getMessage().getHeaders()) {
            if (!message.getHeaders().containsKey((Object)name)) continue;
            String key = traceKeys.getMessage().getPrefix() + name.toLowerCase();
            Object value = message.getHeaders().get((Object)name);
            if (value == null) {
                value = "null";
            }
            this.tagIfEntryMissing(span, key, value.toString());
        }
        this.addPayloadAnnotations(traceKeys, message.getPayload(), span);
    }

    private void addPayloadAnnotations(TraceKeys traceKeys, Object payload, Span span) {
        if (payload != null) {
            this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getType(), payload.getClass().getCanonicalName());
            if (payload instanceof String) {
                this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getSize(), String.valueOf(((String)payload).length()));
            } else if (payload instanceof byte[]) {
                this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getSize(), String.valueOf(((byte[])payload).length));
            }
        }
    }

    private void tagIfEntryMissing(Span span, String key, String value) {
        if (!span.tags().containsKey(key)) {
            span.tag(key, value);
        }
    }

    private void addHeader(Map<String, String> headers, String name, String value) {
        if (StringUtils.hasText((String)value)) {
            headers.put(name, value);
        }
    }

    private Long getFirst(List<Long> parents) {
        return parents.isEmpty() ? null : parents.get(0);
    }
}

