/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.AbstractTraceChannelInterceptor;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.MessageBuilder;

public class TraceChannelInterceptor
extends AbstractTraceChannelInterceptor {
    private static final String SPAN_HEADER = "X-Current-Span";
    private static final String MESSAGE_SENT_FROM_CLIENT = "X-Message-Sent";

    public TraceChannelInterceptor(Tracer tracer, TraceKeys traceKeys, SpanExtractor<Message<?>> spanExtractor, SpanInjector<MessageBuilder<?>> spanInjector) {
        super(tracer, traceKeys, spanExtractor, spanInjector);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        Span spanFromHeader = this.getSpanFromHeader(message);
        if (this.containsServerReceived(spanFromHeader)) {
            spanFromHeader.logEvent("ss");
        } else if (spanFromHeader != null) {
            spanFromHeader.logEvent("cr");
        }
        this.getTracer().close(spanFromHeader);
    }

    private boolean containsServerReceived(Span span) {
        if (span == null) {
            return false;
        }
        for (Log log : span.logs()) {
            if (!"sr".equals(log.getEvent())) continue;
            return true;
        }
        return false;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        Span parentSpan = this.getTracer().isTracing() ? this.getTracer().getCurrentSpan() : this.buildSpan(message);
        String name = this.getMessageChannelName(channel);
        Span span = this.startSpan(parentSpan, name, message);
        MessageBuilder messageBuilder = MessageBuilder.fromMessage(message);
        if (message.getHeaders().containsKey((Object)MESSAGE_SENT_FROM_CLIENT)) {
            span.logEvent("sr");
        } else {
            span.logEvent("cs");
            messageBuilder.setHeader(MESSAGE_SENT_FROM_CLIENT, (Object)true);
        }
        this.getSpanInjector().inject(span, messageBuilder);
        return messageBuilder.build();
    }

    private Span startSpan(Span span, String name, Message<?> message) {
        if (span != null) {
            return this.getTracer().createSpan(name, span);
        }
        if ("0".equals(message.getHeaders().get((Object)"X-B3-Sampled"))) {
            return this.getTracer().createSpan(name, NeverSampler.INSTANCE);
        }
        return this.getTracer().createSpan(name);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        Span spanFromHeader = this.getSpanFromHeader(message);
        if (spanFromHeader != null) {
            spanFromHeader.logEvent("sr");
        }
        this.getTracer().continueSpan(spanFromHeader);
        return message;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        Span spanFromHeader = this.getSpanFromHeader(message);
        if (spanFromHeader != null) {
            spanFromHeader.logEvent("ss");
        }
        this.getTracer().detach(spanFromHeader);
    }

    private Span getSpanFromHeader(Message<?> message) {
        if (message == null) {
            return null;
        }
        Object object = message.getHeaders().get((Object)SPAN_HEADER);
        if (object instanceof Span) {
            return (Span)object;
        }
        return null;
    }
}

