/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.rxjava;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.rxjava.SleuthRxJavaSchedulersHook;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import rx.plugins.RxJavaSchedulersHook;

@Configuration
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={RxJavaSchedulersHook.class})
@ConditionalOnProperty(value={"spring.sleuth.rxjava.schedulers.hook.enabled"}, matchIfMissing=true)
public class RxJavaAutoConfiguration {
    private static final List<String> DEFAULT_IGNORED_THREADS = Arrays.asList("HystrixMetricPoller", "^RxComputation.*$");

    @Bean
    SleuthRxJavaSchedulersHook sleuthRxJavaSchedulersHook(Tracer tracer, TraceKeys traceKeys, @Value(value="${spring.sleuth.rxjava.schedulers.ignoredthreads:}") String threadsToSample) {
        return new SleuthRxJavaSchedulersHook(tracer, traceKeys, this.threads(threadsToSample));
    }

    private List<String> threads(String threadsToSample) {
        ArrayList<String> threads = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)threadsToSample)) {
            threads.addAll(DEFAULT_IGNORED_THREADS);
        } else {
            threads.addAll(Arrays.asList(threadsToSample.split(",")));
        }
        return threads;
    }
}

