/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.HttpServletRequestExtractor;
import org.springframework.cloud.sleuth.instrument.web.HttpServletResponseInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.cloud.sleuth.instrument.web.TraceSpringDataBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAspect;
import org.springframework.cloud.sleuth.instrument.web.TraceWebMvcConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceKeys.class})
@Import(value={TraceWebMvcConfigurer.class})
public class TraceWebAutoConfiguration {
    @Value(value="${spring.sleuth.web.skipPattern:}")
    private String skipPattern;

    @Bean
    public TraceWebAspect traceWebAspect(Tracer tracer, SpanNamer spanNamer) {
        return new TraceWebAspect(tracer, spanNamer);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping"})
    public TraceSpringDataBeanPostProcessor traceSpringDataBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceSpringDataBeanPostProcessor(beanFactory);
    }

    @Bean
    public FilterRegistrationBean traceWebFilter(Tracer tracer, TraceKeys traceKeys, SkipPatternProvider skipPatternProvider, SpanReporter spanReporter, SpanExtractor<HttpServletRequest> spanExtractor, SpanInjector<HttpServletResponse> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector, TraceFilter traceFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)traceFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        return filterRegistrationBean;
    }

    @Bean
    public TraceFilter traceFilter(Tracer tracer, TraceKeys traceKeys, SkipPatternProvider skipPatternProvider, SpanReporter spanReporter, SpanExtractor<HttpServletRequest> spanExtractor, SpanInjector<HttpServletResponse> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        return new TraceFilter(tracer, traceKeys, skipPatternProvider.skipPattern(), spanReporter, spanExtractor, spanInjector, httpTraceKeysInjector);
    }

    @Bean
    public SpanExtractor<HttpServletRequest> httpServletRequestSpanExtractor(SkipPatternProvider skipPatternProvider) {
        return new HttpServletRequestExtractor(skipPatternProvider.skipPattern());
    }

    @Bean
    public SpanInjector<HttpServletResponse> httpServletResponseSpanInjector() {
        return new HttpServletResponseInjector();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties"})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    public SkipPatternProvider defaultSkipPatternBean() {
        return TraceWebAutoConfiguration.defaultSkipPatternProvider(this.skipPattern);
    }

    private static SkipPatternProvider defaultSkipPatternProvider(final String skipPattern) {
        return new SkipPatternProvider(){

            @Override
            public Pattern skipPattern() {
                return TraceWebAutoConfiguration.defaultSkipPattern(skipPattern);
            }
        };
    }

    private static Pattern defaultSkipPattern(String skipPattern) {
        return StringUtils.hasText((String)skipPattern) ? Pattern.compile(skipPattern) : Pattern.compile("/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream");
    }

    static interface SkipPatternProvider {
        public Pattern skipPattern();
    }

    @Configuration
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    protected static class SkipPatternProviderConfig {
        @Value(value="${spring.sleuth.web.skipPattern:}")
        private String skipPattern;

        protected SkipPatternProviderConfig() {
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SkipPatternProvider skipPatternForManagementServerProperties(final ManagementServerProperties managementServerProperties) {
            return new SkipPatternProvider(){

                @Override
                public Pattern skipPattern() {
                    return SkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties, SkipPatternProviderConfig.this.skipPattern);
                }
            };
        }

        static Pattern getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties, String skipPattern) {
            if (StringUtils.hasText((String)skipPattern) && StringUtils.hasText((String)managementServerProperties.getContextPath())) {
                return Pattern.compile(skipPattern + "|" + managementServerProperties.getContextPath() + ".*");
            }
            if (StringUtils.hasText((String)managementServerProperties.getContextPath())) {
                return Pattern.compile(managementServerProperties.getContextPath() + ".*");
            }
            return TraceWebAutoConfiguration.defaultSkipPattern(skipPattern);
        }

        @Bean
        @ConditionalOnMissingBean(value={ManagementServerProperties.class})
        public SkipPatternProvider defaultSkipPatternBeanIfManagementServerPropsArePresent() {
            return TraceWebAutoConfiguration.defaultSkipPatternProvider(this.skipPattern);
        }
    }
}

