/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.net.URI;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class TraceAsyncRestTemplate
extends AsyncRestTemplate {
    private final Tracer tracer;

    public TraceAsyncRestTemplate(Tracer tracer) {
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncListenableTaskExecutor taskExecutor, Tracer tracer) {
        super(taskExecutor);
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, Tracer tracer) {
        super(asyncRequestFactory);
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, ClientHttpRequestFactory syncRequestFactory, Tracer tracer) {
        super(asyncRequestFactory, syncRequestFactory);
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory requestFactory, RestTemplate restTemplate, Tracer tracer) {
        super(requestFactory, restTemplate);
        this.tracer = tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> ListenableFuture<T> doExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        try {
            ListenableFuture listenableFuture = super.doExecute(url, method, requestCallback, responseExtractor);
            return listenableFuture;
        }
        finally {
            this.finish();
        }
    }

    private void finish() {
        if (!this.isTracing()) {
            return;
        }
        this.currentSpan().logEvent("cr");
        this.tracer.close(this.currentSpan());
    }

    private Span currentSpan() {
        return this.tracer.getCurrentSpan();
    }

    private boolean isTracing() {
        return this.tracer.isTracing();
    }
}

