/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.feign.FeignContext;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignContext;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;

final class FeignContextBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private TraceFeignObjectWrapper traceFeignObjectWrapper;

    FeignContextBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof FeignContext) {
            return new TraceFeignContext(this.getTraceFeignObjectWrapper(), (FeignContext)bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    TraceFeignObjectWrapper getTraceFeignObjectWrapper() {
        if (this.traceFeignObjectWrapper == null) {
            this.traceFeignObjectWrapper = (TraceFeignObjectWrapper)this.beanFactory.getBean(TraceFeignObjectWrapper.class);
        }
        return this.traceFeignObjectWrapper;
    }
}

