/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignRequestContext;

abstract class FeignEventPublisher {
    private final FeignRequestContext feignRequestContext = FeignRequestContext.getInstance();
    protected final BeanFactory beanFactory;
    private Tracer tracer;

    protected FeignEventPublisher(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected void finish() {
        Span span = this.feignRequestContext.getCurrentSpan();
        if (span != null) {
            span.logEvent("cr");
            this.getTracer().close(span);
            this.feignRequestContext.clearContext();
        }
    }

    Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

