/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import org.springframework.cloud.sleuth.Span;

final class FeignRequestContext {
    private static final FeignRequestContext INSTANCE = new FeignRequestContext();
    private static final ThreadLocal<SpanHolder> THREAD_LOCAL = new ThreadLocal();

    private FeignRequestContext() {
    }

    boolean hasSpanInProcess() {
        return THREAD_LOCAL.get() != null;
    }

    Span getCurrentSpan() {
        if (this.hasSpanInProcess()) {
            return FeignRequestContext.THREAD_LOCAL.get().span;
        }
        return null;
    }

    boolean wasSpanRetried() {
        return this.hasSpanInProcess() && FeignRequestContext.THREAD_LOCAL.get().retried;
    }

    void putSpan(Span span, boolean retried) {
        THREAD_LOCAL.set(new SpanHolder(span, retried));
    }

    void clearContext() {
        THREAD_LOCAL.remove();
    }

    static FeignRequestContext getInstance() {
        return INSTANCE;
    }

    private static final class SpanHolder {
        final Span span;
        final boolean retried;

        private SpanHolder(Span span, boolean retried) {
            this.span = span;
            this.retried = retried;
        }
    }
}

