/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.RetryableException;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignEventPublisher;

final class TraceFeignClient
extends FeignEventPublisher
implements Client {
    private final Client delegate;
    private HttpTraceKeysInjector keysInjector;

    TraceFeignClient(BeanFactory beanFactory) {
        super(beanFactory);
        this.delegate = new Client.Default(null, null);
    }

    TraceFeignClient(BeanFactory beanFactory, Client delegate) {
        super(beanFactory);
        this.delegate = delegate;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        Response response;
        try {
            this.addRequestTags(request);
            response = this.delegate.execute(request, options);
        }
        catch (RetryableException | IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        if (response != null && response.body() == null || response.body() != null && Objects.equals(response.body().length(), 0)) {
            this.finish();
        }
        return response;
    }

    private void addRequestTags(Request request) {
        URI uri = URI.create(request.url());
        this.getKeysInjector().addRequestTags(uri.toString(), uri.getHost(), uri.getPath(), request.method(), request.headers());
    }

    HttpTraceKeysInjector getKeysInjector() {
        if (this.keysInjector == null) {
            this.keysInjector = (HttpTraceKeysInjector)this.beanFactory.getBean(HttpTraceKeysInjector.class);
        }
        return this.keysInjector;
    }
}

