/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import com.netflix.hystrix.HystrixCommand;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.Type;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.cloud.netflix.feign.FeignAutoConfiguration;
import org.springframework.cloud.netflix.feign.support.ResponseEntityDecoder;
import org.springframework.cloud.netflix.feign.support.SpringDecoder;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.hystrix.SleuthHystrixAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignContextBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignRequestContext;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignRequestTemplateInjector;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignResponseHeadersHolder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignResponseHeadersInjector;
import org.springframework.cloud.sleuth.instrument.web.client.feign.SleuthFeignBuilder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignDecoder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignRequestInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.feign.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Client.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@AutoConfigureAfter(value={SleuthHystrixAutoConfiguration.class})
public class TraceFeignClientAutoConfiguration {
    @Autowired
    private ObjectFactory<HttpMessageConverters> messageConverters;

    @Bean
    @Scope(value="prototype")
    @ConditionalOnClass(value={HystrixCommand.class})
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, matchIfMissing=true)
    Feign.Builder feignHystrixBuilder(BeanFactory beanFactory) {
        return SleuthFeignBuilder.builder(beanFactory);
    }

    @Bean
    TraceFeignObjectWrapper traceFeignObjectWrapper(BeanFactory beanFactory) {
        return new TraceFeignObjectWrapper(beanFactory);
    }

    @Bean
    @Primary
    Decoder feignDecoder(BeanFactory beanFactory) {
        return new TraceFeignDecoder(beanFactory, (Decoder)new ResponseEntityDecoder((Decoder)new SpringDecoder(this.messageConverters)){

            public Object decode(Response response, Type type) throws IOException, FeignException {
                FeignRequestContext feignRequestContext = FeignRequestContext.getInstance();
                FeignResponseHeadersHolder feignResponseHeadersHolder = new FeignResponseHeadersHolder(response.headers());
                TraceFeignClientAutoConfiguration.this.feignResponseHeadersInjector().inject(feignRequestContext.getCurrentSpan(), feignResponseHeadersHolder);
                return super.decode(Response.create((int)response.status(), (String)response.reason(), feignResponseHeadersHolder.responseHeaders, (Response.Body)response.body()), type);
            }
        });
    }

    @Bean
    RequestInterceptor traceIdRequestInterceptor(Tracer tracer) {
        return new TraceFeignRequestInterceptor(tracer, this.feignRequestTemplateInjector());
    }

    private SpanInjector<RequestTemplate> feignRequestTemplateInjector() {
        return new FeignRequestTemplateInjector();
    }

    private SpanInjector<FeignResponseHeadersHolder> feignResponseHeadersInjector() {
        return new FeignResponseHeadersInjector();
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.sleuth.feign.processor.enabled"}, matchIfMissing=true)
    protected static class FeignBeanPostProcessorConfiguration {
        protected FeignBeanPostProcessorConfiguration() {
        }

        @Bean
        FeignBeanPostProcessor feignBeanPostProcessor(TraceFeignObjectWrapper traceFeignObjectWrapper) {
            return new FeignBeanPostProcessor(traceFeignObjectWrapper);
        }

        @Bean
        FeignContextBeanPostProcessor feignContextBeanPostProcessor(BeanFactory beanFactory) {
            return new FeignContextBeanPostProcessor(beanFactory);
        }
    }
}

