/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignDecoder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignErrorDecoder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignRetryer;

final class TraceFeignObjectWrapper {
    private final BeanFactory beanFactory;

    TraceFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean) {
        if (bean instanceof Decoder && !(bean instanceof TraceFeignDecoder)) {
            return new TraceFeignDecoder(this.beanFactory, (Decoder)bean);
        }
        if (bean instanceof Retryer && !(bean instanceof TraceFeignRetryer)) {
            return new TraceFeignRetryer(this.beanFactory, (Retryer)bean);
        }
        if (bean instanceof Client && !(bean instanceof TraceFeignClient)) {
            return new TraceFeignClient(this.beanFactory, (Client)bean);
        }
        if (bean instanceof ErrorDecoder && !(bean instanceof TraceFeignErrorDecoder)) {
            return new TraceFeignErrorDecoder(this.beanFactory, (ErrorDecoder)bean);
        }
        return bean;
    }
}

