/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;

public class TracePostZuulFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Tracer tracer;
    private final TraceKeys traceKeys;

    public TracePostZuulFilter(Tracer tracer, TraceKeys traceKeys) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
    }

    public boolean shouldFilter() {
        return this.getCurrentSpan() != null;
    }

    public Object run() {
        int httpStatus;
        this.getCurrentSpan().logEvent("cr");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing current client span " + this.getCurrentSpan()));
        }
        if ((httpStatus = RequestContext.getCurrentContext().getResponse().getStatus()) > 0) {
            this.tracer.addTag(this.traceKeys.getHttp().getStatusCode(), String.valueOf(httpStatus));
        }
        this.tracer.close(this.getCurrentSpan());
        return null;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }

    private Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }
}

