/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import java.util.concurrent.Callable;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;

public class TraceCallable<V>
implements Callable<V> {
    private final Tracer tracer;
    private final SpanNamer spanNamer;
    private final Callable<V> delegate;
    private final String name;
    private final Span parent;

    public TraceCallable(Tracer tracer, SpanNamer spanNamer, Callable<V> delegate) {
        this(tracer, spanNamer, delegate, null);
    }

    public TraceCallable(Tracer tracer, SpanNamer spanNamer, Callable<V> delegate, String name) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
        this.delegate = delegate;
        this.name = name;
        this.parent = tracer.getCurrentSpan();
    }

    @Override
    public V call() throws Exception {
        Span span = this.startSpan();
        try {
            V v = this.getDelegate().call();
            return v;
        }
        finally {
            this.close(span);
        }
    }

    protected Span startSpan() {
        return this.tracer.createSpan(this.getSpanName(), this.parent);
    }

    protected String getSpanName() {
        if (this.name != null) {
            return this.name;
        }
        return this.spanNamer.name(this.delegate, "async");
    }

    protected void close(Span span) {
        this.tracer.close(span);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public Callable<V> getDelegate() {
        return this.delegate;
    }

    public String getName() {
        return this.name;
    }

    public Span getParent() {
        return this.parent;
    }
}

