/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LocalComponentTraceCallable;
import org.springframework.cloud.sleuth.instrument.async.LocalComponentTraceRunnable;

public class TraceableExecutorService
implements ExecutorService {
    final ExecutorService delegate;
    final Tracer tracer;
    private final String spanName;
    final TraceKeys traceKeys;
    final SpanNamer spanNamer;

    public TraceableExecutorService(ExecutorService delegate, Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer) {
        this(delegate, tracer, traceKeys, spanNamer, null);
    }

    public TraceableExecutorService(ExecutorService delegate, Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, String spanName) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.spanName = spanName;
        this.traceKeys = traceKeys;
        this.spanNamer = spanNamer;
    }

    @Override
    public void execute(Runnable command) {
        LocalComponentTraceRunnable r = new LocalComponentTraceRunnable(this.tracer, this.traceKeys, this.spanNamer, command, this.spanName);
        this.delegate.execute(r);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        LocalComponentTraceCallable<T> c = new LocalComponentTraceCallable<T>(this.tracer, this.traceKeys, this.spanNamer, this.spanName, task);
        return this.delegate.submit(c);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        LocalComponentTraceRunnable r = new LocalComponentTraceRunnable(this.tracer, this.traceKeys, this.spanNamer, task, this.spanName);
        return this.delegate.submit(r, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        LocalComponentTraceRunnable r = new LocalComponentTraceRunnable(this.tracer, this.traceKeys, this.spanNamer, task, this.spanName);
        return this.delegate.submit(r);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapCallableCollection(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapCallableCollection(tasks), timeout, unit);
    }

    private <T> Collection<? extends Callable<T>> wrapCallableCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<LocalComponentTraceCallable<T>> ts = new ArrayList<LocalComponentTraceCallable<T>>();
        for (Callable<T> task : tasks) {
            if (task instanceof LocalComponentTraceCallable) continue;
            ts.add(new LocalComponentTraceCallable<T>(this.tracer, this.traceKeys, this.spanNamer, this.spanName, task));
        }
        return ts;
    }
}

