/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.hystrix;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;

public class SleuthHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private static final String HYSTRIX_COMPONENT = "hystrix";
    private static final Log log = LogFactory.getLog(SleuthHystrixConcurrencyStrategy.class);
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private HystrixConcurrencyStrategy delegate;

    public SleuthHystrixConcurrencyStrategy(Tracer tracer, TraceKeys traceKeys) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        try {
            this.delegate = HystrixPlugins.getInstance().getConcurrencyStrategy();
            if (this.delegate instanceof SleuthHystrixConcurrencyStrategy) {
                return;
            }
            HystrixCommandExecutionHook commandExecutionHook = HystrixPlugins.getInstance().getCommandExecutionHook();
            HystrixEventNotifier eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
            HystrixMetricsPublisher metricsPublisher = HystrixPlugins.getInstance().getMetricsPublisher();
            HystrixPropertiesStrategy propertiesStrategy = HystrixPlugins.getInstance().getPropertiesStrategy();
            this.logCurrentStateOfHysrixPlugins(eventNotifier, metricsPublisher, propertiesStrategy);
            HystrixPlugins.reset();
            HystrixPlugins.getInstance().registerConcurrencyStrategy((HystrixConcurrencyStrategy)this);
            HystrixPlugins.getInstance().registerCommandExecutionHook(commandExecutionHook);
            HystrixPlugins.getInstance().registerEventNotifier(eventNotifier);
            HystrixPlugins.getInstance().registerMetricsPublisher(metricsPublisher);
            HystrixPlugins.getInstance().registerPropertiesStrategy(propertiesStrategy);
        }
        catch (Exception e) {
            log.error((Object)"Failed to register Sleuth Hystrix Concurrency Strategy", (Throwable)e);
        }
    }

    private void logCurrentStateOfHysrixPlugins(HystrixEventNotifier eventNotifier, HystrixMetricsPublisher metricsPublisher, HystrixPropertiesStrategy propertiesStrategy) {
        log.debug((Object)("Current Hystrix plugins configuration is [concurrencyStrategy [" + this.delegate + "]," + "eventNotifier [" + eventNotifier + "]," + "metricPublisher [" + metricsPublisher + "]," + "propertiesStrategy [" + propertiesStrategy + "]," + "]"));
        log.debug((Object)"Registering Sleuth Hystrix Concurrency Strategy.");
    }

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        Callable wrappedCallable;
        if (callable instanceof HystrixTraceCallable) {
            return callable;
        }
        Callable callable2 = wrappedCallable = this.delegate != null ? this.delegate.wrapCallable(callable) : callable;
        if (wrappedCallable instanceof HystrixTraceCallable) {
            return wrappedCallable;
        }
        return new HystrixTraceCallable(this.tracer, this.traceKeys, wrappedCallable);
    }

    static class HystrixTraceCallable<S>
    implements Callable<S> {
        private Tracer tracer;
        private TraceKeys traceKeys;
        private Callable<S> callable;
        private Span parent;

        public HystrixTraceCallable(Tracer tracer, TraceKeys traceKeys, Callable<S> callable) {
            this.tracer = tracer;
            this.traceKeys = traceKeys;
            this.callable = callable;
            this.parent = tracer.getCurrentSpan();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public S call() throws Exception {
            Span span = this.parent;
            boolean created = false;
            if (span != null) {
                span = this.tracer.continueSpan(span);
            } else {
                span = this.tracer.createSpan(SleuthHystrixConcurrencyStrategy.HYSTRIX_COMPONENT);
                this.tracer.addTag("lc", SleuthHystrixConcurrencyStrategy.HYSTRIX_COMPONENT);
                this.tracer.addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getThreadNameKey(), Thread.currentThread().getName());
                created = true;
            }
            try {
                S s = this.callable.call();
                return s;
            }
            finally {
                if (created) {
                    this.tracer.close(span);
                } else {
                    this.tracer.detach(span);
                }
            }
        }
    }
}

