/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.StringUtils;

class MessagingSpanInjector
implements SpanInjector<MessageBuilder<?>> {
    private final TraceKeys traceKeys;

    public MessagingSpanInjector(TraceKeys traceKeys) {
        this.traceKeys = traceKeys;
    }

    @Override
    public void inject(Span span, MessageBuilder<?> carrier) {
        Message initialMessage = carrier.build();
        MessageHeaderAccessor accessor = MessageHeaderAccessor.getMutableAccessor((Message)initialMessage);
        if (span == null) {
            if (!this.isSampled(initialMessage, "X-B3-Sampled") || !this.isSampled(initialMessage, "spanSampled")) {
                accessor.setHeader("X-B3-Sampled", (Object)"0");
                accessor.setHeader("spanSampled", (Object)"0");
                carrier.setHeaders(accessor);
                return;
            }
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.addOldHeaders(span, initialMessage, accessor, headers);
        this.addNewHeaders(span, initialMessage, accessor, headers);
        accessor.copyHeaders(headers);
        if (accessor instanceof NativeMessageHeaderAccessor) {
            NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
            for (String name : headers.keySet()) {
                nativeAccessor.setNativeHeader(name, (String)headers.get(name));
            }
        }
        carrier.setHeaders(accessor);
    }

    private boolean isSampled(Message<?> initialMessage, String sampledHeaderName) {
        return "1".equals(initialMessage.getHeaders().get((Object)sampledHeaderName));
    }

    private void addOldHeaders(Span span, Message<?> initialMessage, MessageHeaderAccessor accessor, Map<String, String> headers) {
        this.addHeaders(span, initialMessage, accessor, headers, "X-B3-TraceId", "X-B3-SpanId", "X-B3-ParentSpanId", "X-Span-Name", "X-Process-Id", "X-B3-Sampled", "X-Current-Span");
    }

    private void addNewHeaders(Span span, Message<?> initialMessage, MessageHeaderAccessor accessor, Map<String, String> headers) {
        this.addHeaders(span, initialMessage, accessor, headers, "spanTraceId", "spanId", "spanParentSpanId", "spanName", "spanProcessId", "spanSampled", "currentSpan");
    }

    private void addHeaders(Span span, Message<?> initialMessage, MessageHeaderAccessor accessor, Map<String, String> headers, String traceIdHeader, String spanIdHeader, String parentIdHeader, String spanNameHeader, String processIdHeader, String spanSampledHeader, String spanHeader) {
        this.addHeader(headers, traceIdHeader, Span.idToHex(span.getTraceId()));
        this.addHeader(headers, spanIdHeader, Span.idToHex(span.getSpanId()));
        if (span.isExportable()) {
            this.addAnnotations(this.traceKeys, initialMessage, span);
            Long parentId = this.getFirst(span.getParents());
            if (parentId != null) {
                this.addHeader(headers, parentIdHeader, Span.idToHex(parentId));
            }
            this.addHeader(headers, spanNameHeader, span.getName());
            this.addHeader(headers, processIdHeader, span.getProcessId());
            this.addHeader(headers, spanSampledHeader, "1");
        } else {
            this.addHeader(headers, spanSampledHeader, "0");
        }
        accessor.setHeader(spanHeader, (Object)span);
    }

    private void addAnnotations(TraceKeys traceKeys, Message<?> message, Span span) {
        for (String name : traceKeys.getMessage().getHeaders()) {
            if (!message.getHeaders().containsKey((Object)name)) continue;
            String key = traceKeys.getMessage().getPrefix() + name.toLowerCase();
            Object value = message.getHeaders().get((Object)name);
            if (value == null) {
                value = "null";
            }
            this.tagIfEntryMissing(span, key, value.toString());
        }
        this.addPayloadAnnotations(traceKeys, message.getPayload(), span);
    }

    private void addPayloadAnnotations(TraceKeys traceKeys, Object payload, Span span) {
        if (payload != null) {
            this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getType(), payload.getClass().getCanonicalName());
            if (payload instanceof String) {
                this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getSize(), String.valueOf(((String)payload).length()));
            } else if (payload instanceof byte[]) {
                this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getSize(), String.valueOf(((byte[])payload).length));
            }
        }
    }

    private void tagIfEntryMissing(Span span, String key, String value) {
        if (!span.tags().containsKey(key)) {
            span.tag(key, value);
        }
    }

    private void addHeader(Map<String, String> headers, String name, String value) {
        if (StringUtils.hasText((String)value)) {
            headers.put(name, value);
        }
    }

    private Long getFirst(List<Long> parents) {
        return parents.isEmpty() ? null : parents.get(0);
    }
}

