/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.ServletUtils;
import org.springframework.cloud.sleuth.instrument.web.TraceRequestAttributes;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.UrlPathHelper;

@Order(value=-2147483643)
public class TraceFilter
extends GenericFilterBean {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String HTTP_COMPONENT = "http";
    protected static final String TRACE_REQUEST_ATTR = TraceFilter.class.getName() + ".TRACE";
    protected static final String TRACE_ERROR_HANDLED_REQUEST_ATTR = TraceFilter.class.getName() + ".ERROR_HANDLED";
    public static final String DEFAULT_SKIP_PATTERN = "/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final Pattern skipPattern;
    private final SpanReporter spanReporter;
    private final SpanExtractor<HttpServletRequest> spanExtractor;
    private final SpanInjector<HttpServletResponse> spanInjector;
    private final HttpTraceKeysInjector httpTraceKeysInjector;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public TraceFilter(Tracer tracer, TraceKeys traceKeys, SpanReporter spanReporter, SpanExtractor<HttpServletRequest> spanExtractor, SpanInjector<HttpServletResponse> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        this(tracer, traceKeys, Pattern.compile(DEFAULT_SKIP_PATTERN), spanReporter, spanExtractor, spanInjector, httpTraceKeysInjector);
    }

    public TraceFilter(Tracer tracer, TraceKeys traceKeys, Pattern skipPattern, SpanReporter spanReporter, SpanExtractor<HttpServletRequest> spanExtractor, SpanInjector<HttpServletResponse> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.skipPattern = skipPattern;
        this.spanReporter = spanReporter;
        this.spanExtractor = spanExtractor;
        this.spanInjector = spanInjector;
        this.httpTraceKeysInjector = httpTraceKeysInjector;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Filter just supports HTTP requests");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        boolean skip = this.skipPattern.matcher(uri).matches() || "0".equals(ServletUtils.getHeader(request, response, "X-B3-Sampled"));
        Span spanFromRequest = this.getSpanFromAttribute(request);
        if (spanFromRequest != null) {
            this.continueSpan(request, spanFromRequest);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a request to uri [" + uri + "] that should be skipped [" + skip + "]"));
        }
        if (!this.httpStatusSuccessful(response) && this.isSpanContinued(request)) {
            this.processErrorRequest(filterChain, request, response, spanFromRequest);
            return;
        }
        this.addToResponseIfNotPresent(response, "X-B3-Sampled", skip ? "0" : "1");
        String name = "http:" + uri;
        try {
            spanFromRequest = this.createSpan(request, skip, spanFromRequest, name);
        }
        catch (IllegalArgumentException e) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            response.sendError(HttpStatus.BAD_REQUEST.value(), "Exception tracing request [" + e.getMessage() + "]");
            return;
        }
        Throwable exception = null;
        try {
            this.spanInjector.inject(spanFromRequest, response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable e) {
            try {
                exception = e;
                throw e;
            }
            catch (Throwable throwable) {
                if (this.isAsyncStarted(request) || request.isAsyncStarted()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The span " + spanFromRequest + " will get detached by a HandleInterceptor"));
                    }
                    return;
                }
                spanFromRequest = this.createSpanIfRequestNotHandled(request, spanFromRequest, name, skip);
                this.addToResponseIfNotPresent(response, "X-B3-Sampled", skip ? "0" : "1");
                this.detachOrCloseSpans(request, response, spanFromRequest, exception);
                throw throwable;
            }
        }
        if (this.isAsyncStarted(request) || request.isAsyncStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The span " + spanFromRequest + " will get detached by a HandleInterceptor"));
            }
            return;
        }
        spanFromRequest = this.createSpanIfRequestNotHandled(request, spanFromRequest, name, skip);
        this.addToResponseIfNotPresent(response, "X-B3-Sampled", skip ? "0" : "1");
        this.detachOrCloseSpans(request, response, spanFromRequest, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processErrorRequest(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response, Span spanFromRequest) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The span [" + spanFromRequest + "] was already detached once and we're processing an error"));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            request.setAttribute(TRACE_ERROR_HANDLED_REQUEST_ATTR, (Object)true);
            this.addResponseTags(response, null);
            this.tracer.close(spanFromRequest);
        }
    }

    private void continueSpan(HttpServletRequest request, Span spanFromRequest) {
        this.tracer.continueSpan(spanFromRequest);
        request.setAttribute(TraceRequestAttributes.SPAN_CONTINUED_REQUEST_ATTR, (Object)"true");
        if (log.isDebugEnabled()) {
            log.debug((Object)("There has already been a span in the request " + spanFromRequest));
        }
    }

    private Span createSpanIfRequestNotHandled(HttpServletRequest request, Span spanFromRequest, String name, boolean skip) {
        if (!this.requestHasAlreadyBeenHandled(request)) {
            spanFromRequest = this.tracer.createSpan(name);
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
            if (log.isDebugEnabled() && !skip) {
                log.debug((Object)("The request with uri [" + request.getRequestURI() + "] hasn't been handled by any of Sleuth's components. " + "That means that most likely you're using custom HandlerMappings and didn't add Sleuth's TraceHandlerInterceptor. " + "Sleuth will create a span to ensure that the graph of calls remains valid in Zipkin"));
            }
        }
        return spanFromRequest;
    }

    private boolean requestHasAlreadyBeenHandled(HttpServletRequest request) {
        return request.getAttribute(TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR) != null;
    }

    private void detachOrCloseSpans(HttpServletRequest request, HttpServletResponse response, Span spanFromRequest, Throwable exception) {
        if (spanFromRequest != null) {
            this.addResponseTags(response, exception);
            if (spanFromRequest.hasSavedSpan() && this.requestHasAlreadyBeenHandled(request)) {
                this.recordParentSpan(spanFromRequest.getSavedSpan());
            } else if (!this.requestHasAlreadyBeenHandled(request)) {
                spanFromRequest = this.tracer.close(spanFromRequest);
            }
            this.recordParentSpan(spanFromRequest);
            if (this.httpStatusSuccessful(response)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing the span " + spanFromRequest + " since the response was successful"));
                }
                this.tracer.close(spanFromRequest);
            } else if (this.errorAlreadyHandled(request)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Won't detach the span " + spanFromRequest + " since error has already been handled"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Detaching the span " + spanFromRequest + " since the response was unsuccessful"));
                }
                this.tracer.detach(spanFromRequest);
            }
        }
    }

    private void recordParentSpan(Span parent) {
        if (parent == null) {
            return;
        }
        if (parent.isRemote()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending the parent span " + parent + " to Zipkin"));
            }
            parent.stop();
            parent.logEvent("ss");
            this.spanReporter.report(parent);
        } else {
            parent.logEvent("ss");
        }
    }

    private boolean httpStatusSuccessful(HttpServletResponse response) {
        if (response.getStatus() == 0) {
            return false;
        }
        HttpStatus httpStatus = HttpStatus.valueOf((int)response.getStatus());
        return httpStatus.is2xxSuccessful() || httpStatus.is3xxRedirection();
    }

    private Span getSpanFromAttribute(HttpServletRequest request) {
        return (Span)request.getAttribute(TRACE_REQUEST_ATTR);
    }

    private boolean errorAlreadyHandled(HttpServletRequest request) {
        return Boolean.valueOf(String.valueOf(request.getAttribute(TRACE_ERROR_HANDLED_REQUEST_ATTR)));
    }

    private boolean isSpanContinued(HttpServletRequest request) {
        return this.getSpanFromAttribute(request) != null;
    }

    private void addRequestTagsForParentSpan(HttpServletRequest request, Span spanFromRequest) {
        if (spanFromRequest.getName().contains("parent")) {
            this.addRequestTags(spanFromRequest, request);
        }
    }

    private Span createSpan(HttpServletRequest request, boolean skip, Span spanFromRequest, String name) {
        if (spanFromRequest != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Span has already been created - continuing with the previous one");
            }
            return spanFromRequest;
        }
        Span parent = this.spanExtractor.joinTrace(request);
        if (parent != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a parent span " + parent + " in the request"));
            }
            this.addRequestTagsForParentSpan(request, parent);
            spanFromRequest = parent;
            this.tracer.continueSpan(spanFromRequest);
            if (parent.isRemote()) {
                parent.logEvent("sr");
            }
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parent span is " + parent + ""));
            }
        } else {
            spanFromRequest = skip ? this.tracer.createSpan(name, NeverSampler.INSTANCE) : this.tracer.createSpan(name);
            spanFromRequest.logEvent("sr");
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
            log.debug((Object)"No parent span present - creating a new span");
        }
        return spanFromRequest;
    }

    protected void addRequestTags(Span span, HttpServletRequest request) {
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        this.httpTraceKeysInjector.addRequestTags(span, this.getFullUrl(request), request.getServerName(), uri, request.getMethod());
        for (String name : this.traceKeys.getHttp().getHeaders()) {
            Enumeration values = request.getHeaders(name);
            if (!values.hasMoreElements()) continue;
            String key = this.traceKeys.getHttp().getPrefix() + name.toLowerCase();
            ArrayList list = Collections.list(values);
            String value = list.size() == 1 ? (String)list.get(0) : StringUtils.collectionToDelimitedString(list, (String)",", (String)"'", (String)"'");
            this.httpTraceKeysInjector.tagSpan(span, key, value);
        }
    }

    protected void addResponseTags(HttpServletResponse response, Throwable e) {
        int httpStatus = response.getStatus();
        if (httpStatus == 200 && e != null) {
            this.tracer.addTag(this.traceKeys.getHttp().getStatusCode(), String.valueOf(500));
        } else if (httpStatus >= 100 && httpStatus < 200 || httpStatus > 399) {
            this.tracer.addTag(this.traceKeys.getHttp().getStatusCode(), String.valueOf(response.getStatus()));
        }
    }

    private void addToResponseIfNotPresent(HttpServletResponse response, String name, String value) {
        if (!StringUtils.hasText((String)response.getHeader(name))) {
            response.addHeader(name, value);
        }
    }

    protected boolean isAsyncStarted(HttpServletRequest request) {
        return WebAsyncUtils.getAsyncManager((ServletRequest)request).isConcurrentHandlingStarted();
    }

    private String getFullUrl(HttpServletRequest request) {
        StringBuffer requestURI = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURI.toString();
        }
        return requestURI.append('?').append(queryString).toString();
    }
}

