/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.lang.invoke.MethodHandles;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.cloud.sleuth.instrument.web.TraceRequestAttributes;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TraceHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private TraceKeys traceKeys;
    private ErrorController errorController;

    public TraceHandlerInterceptor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.isErrorControllerRelated(request)) {
            log.debug((Object)"Skipping creation of a span for error controller processing");
            return true;
        }
        if (this.isSpanContinued(request)) {
            log.debug((Object)"Skipping creation of a span since the span is continued");
            return true;
        }
        String spanName = this.spanName(handler);
        Span span = this.getTracer().createSpan(spanName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new span " + span + " with name [" + spanName + "]"));
        }
        this.addClassMethodTag(handler, span);
        this.addClassNameTag(handler, span);
        this.setSpanInAttribute(request, span);
        return true;
    }

    private boolean isErrorControllerRelated(HttpServletRequest request) {
        return this.getErrorController() != null && this.getErrorController().getErrorPath().equals(request.getRequestURI());
    }

    private void addClassMethodTag(Object handler, Span span) {
        if (handler instanceof HandlerMethod) {
            String methodName = SpanNameUtil.toLowerHyphen(((HandlerMethod)handler).getMethod().getName());
            this.getTracer().addTag(this.getTraceKeys().getMvc().getControllerMethod(), methodName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding a method tag with value [" + methodName + "] to a span " + span));
            }
        }
    }

    private void addClassNameTag(Object handler, Span span) {
        String className = handler instanceof HandlerMethod ? SpanNameUtil.toLowerHyphen(((HandlerMethod)handler).getBeanType().getSimpleName()) : SpanNameUtil.toLowerHyphen(handler.getClass().getSimpleName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding a class tag with value [" + className + "] to a span " + span));
        }
        this.getTracer().addTag(this.getTraceKeys().getMvc().getControllerClass(), className);
    }

    private String spanName(Object handler) {
        if (handler instanceof HandlerMethod) {
            return SpanNameUtil.toLowerHyphen(((HandlerMethod)handler).getMethod().getName());
        }
        return SpanNameUtil.toLowerHyphen(handler.getClass().getSimpleName());
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Span spanFromRequest = this.getSpanFromAttribute(request);
        Span rootSpanFromRequest = this.getRootSpanFromAttribute(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing the span " + spanFromRequest + " and detaching its parent " + rootSpanFromRequest + " since the request is asynchronous"));
        }
        this.getTracer().close(spanFromRequest);
        this.getTracer().detach(rootSpanFromRequest);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.isErrorControllerRelated(request)) {
            log.debug((Object)"Skipping closing of a span for error controller processing");
            return;
        }
        if (this.isSpanContinued(request)) {
            log.debug((Object)"Skipping closing of a span since it's been continued");
            return;
        }
        Span span = this.getSpanFromAttribute(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing span " + span));
        }
        this.getTracer().close(span);
    }

    private boolean isSpanContinued(HttpServletRequest request) {
        return request.getAttribute(TraceRequestAttributes.SPAN_CONTINUED_REQUEST_ATTR) != null;
    }

    private Span getSpanFromAttribute(HttpServletRequest request) {
        return (Span)request.getAttribute(TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR);
    }

    private Span getRootSpanFromAttribute(HttpServletRequest request) {
        return (Span)request.getAttribute(TraceFilter.TRACE_REQUEST_ATTR);
    }

    private void setSpanInAttribute(HttpServletRequest request, Span span) {
        request.setAttribute(TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR, (Object)span);
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private TraceKeys getTraceKeys() {
        if (this.traceKeys == null) {
            this.traceKeys = (TraceKeys)this.beanFactory.getBean(TraceKeys.class);
        }
        return this.traceKeys;
    }

    private ErrorController getErrorController() {
        if (this.errorController == null) {
            this.errorController = (ErrorController)this.beanFactory.getBean(ErrorController.class);
        }
        return this.errorController;
    }
}

