/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.http.HttpRequest;

abstract class AbstractTraceHttpRequestInterceptor {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected final Tracer tracer;
    protected final SpanInjector<HttpRequest> spanInjector;
    protected final HttpTraceKeysInjector keysInjector;

    protected AbstractTraceHttpRequestInterceptor(Tracer tracer, SpanInjector<HttpRequest> spanInjector, HttpTraceKeysInjector keysInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
        this.keysInjector = keysInjector;
    }

    protected void publishStartEvent(HttpRequest request) {
        URI uri = request.getURI();
        String spanName = this.uriScheme(uri) + ":" + uri.getPath();
        Span newSpan = this.tracer.createSpan(spanName);
        this.spanInjector.inject(newSpan, request);
        this.addRequestTags(request);
        newSpan.logEvent("cs");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting new client span [" + newSpan + "]"));
        }
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }

    protected void addRequestTags(HttpRequest request) {
        this.keysInjector.addRequestTags(request.getURI().toString(), request.getURI().getHost(), request.getURI().getPath(), request.getMethod().name(), (Map<String, ? extends Collection<String>>)request.getHeaders());
    }

    public void finish() {
        if (!this.isTracing()) {
            return;
        }
        this.currentSpan().logEvent("cr");
        this.tracer.close(this.currentSpan());
    }

    protected Span currentSpan() {
        return this.tracer.getCurrentSpan();
    }

    protected boolean isTracing() {
        return this.tracer.isTracing();
    }
}

