/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.io.IOException;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractTraceHttpRequestInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceHttpResponse;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TraceRestTemplateInterceptor
extends AbstractTraceHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    public TraceRestTemplateInterceptor(Tracer tracer, SpanInjector<HttpRequest> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        super(tracer, spanInjector, httpTraceKeysInjector);
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.publishStartEvent(request);
        return this.response(request, body, execution);
    }

    private ClientHttpResponse response(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            return new TraceHttpResponse(this, execution.execute(request, body));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception occurred while trying to execute the request. Will close the span [" + this.currentSpan() + "]"), (Throwable)e);
            }
            this.tracer.close(this.currentSpan());
            throw e;
        }
    }
}

