/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.RetryableException;
import feign.Retryer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignRequestContext;

final class TraceFeignRetryer
implements Retryer {
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private final FeignRequestContext feignRequestContext = FeignRequestContext.getInstance();
    private final Retryer delegate;

    TraceFeignRetryer(BeanFactory beanFactory) {
        this(beanFactory, (Retryer)new Retryer.Default());
    }

    TraceFeignRetryer(BeanFactory beanFactory, Retryer delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public void continueOrPropagate(RetryableException e) {
        try {
            this.feignRequestContext.putSpan(this.getTracer().getCurrentSpan(), true);
            this.getTracer().getCurrentSpan().logEvent("feign.retry");
            this.delegate.continueOrPropagate(e);
        }
        catch (RetryableException e2) {
            this.getTracer().close(this.getTracer().getCurrentSpan());
            throw e2;
        }
    }

    public Retryer clone() {
        return new TraceFeignRetryer(this.beanFactory, this.delegate.clone());
    }

    Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

