/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.client.http.HttpRequest;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.zuul.RequestBuilderContextInjector;
import org.springframework.cloud.sleuth.instrument.zuul.RequestContextInjector;
import org.springframework.cloud.sleuth.instrument.zuul.TracePostZuulFilter;
import org.springframework.cloud.sleuth.instrument.zuul.TracePreZuulFilter;
import org.springframework.cloud.sleuth.instrument.zuul.TraceRestClientRibbonCommandFactory;
import org.springframework.cloud.sleuth.instrument.zuul.TraceZuulHandlerMappingBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.zuul.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ConditionalOnClass(value={ZuulFilter.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
public class TraceZuulAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TracePreZuulFilter tracePreZuulFilter(Tracer tracer, SpanInjector<RequestContext> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        return new TracePreZuulFilter(tracer, spanInjector, httpTraceKeysInjector);
    }

    @Bean
    public TraceRestClientRibbonCommandFactory traceRestClientRibbonCommandFactory(SpringClientFactory factory, Tracer tracer, SpanInjector<HttpRequest.Builder> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        return new TraceRestClientRibbonCommandFactory(factory, tracer, spanInjector, httpTraceKeysInjector);
    }

    @Bean
    @ConditionalOnMissingBean
    public TracePostZuulFilter tracePostZuulFilter(Tracer tracer, TraceKeys traceKeys) {
        return new TracePostZuulFilter(tracer, traceKeys);
    }

    @Bean
    public SpanInjector<RequestContext> requestContextSpanInjector() {
        return new RequestContextInjector();
    }

    @Bean
    public SpanInjector<HttpRequest.Builder> requestBuilderContextSpanInjector() {
        return new RequestBuilderContextInjector();
    }

    @Bean
    public TraceZuulHandlerMappingBeanPostProcessor traceHandlerMappingBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceZuulHandlerMappingBeanPostProcessor(beanFactory);
    }
}

