/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.web.ZuulController;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.cloud.sleuth.instrument.web.TraceHandlerInterceptor;

class TraceZuulHandlerMappingBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final BeanFactory beanFactory;
    private RouteLocator routeLocator;
    private ZuulController zuul;
    private ErrorController errorController;

    public TraceZuulHandlerMappingBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ZuulHandlerMapping && !(bean instanceof TraceZuulHandlerMapping)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrapping bean [" + beanName + "] of type [" + bean.getClass().getSimpleName() + "] in its trace representation"));
            }
            return new TraceZuulHandlerMapping(this.beanFactory, this.routeLocator(), this.zuulController(), this.errorController());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private RouteLocator routeLocator() {
        if (this.routeLocator == null) {
            this.routeLocator = (RouteLocator)this.beanFactory.getBean(RouteLocator.class);
        }
        return this.routeLocator;
    }

    private ZuulController zuulController() {
        if (this.zuul == null) {
            this.zuul = (ZuulController)this.beanFactory.getBean(ZuulController.class);
        }
        return this.zuul;
    }

    private ErrorController errorController() {
        if (this.errorController == null) {
            try {
                this.errorController = (ErrorController)this.beanFactory.getBean(ErrorController.class);
            }
            catch (BeansException b) {
                return null;
            }
        }
        return this.errorController;
    }

    private static class TraceZuulHandlerMapping
    extends ZuulHandlerMapping {
        private final BeanFactory beanFactory;

        public TraceZuulHandlerMapping(BeanFactory beanFactory, RouteLocator routeLocator, ZuulController zuulController, ErrorController errorController) {
            super(routeLocator, zuulController);
            this.beanFactory = beanFactory;
            this.setErrorController(errorController);
        }

        protected void extendInterceptors(List<Object> interceptors) {
            interceptors.add((Object)new TraceHandlerInterceptor(this.beanFactory));
        }
    }
}

