/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.ContextRefreshedListener;

final class ContextUtil {
    private static final Log log = LogFactory.getLog(ContextUtil.class);

    private ContextUtil() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static boolean isContextInCreation(BeanFactory beanFactory) {
        boolean contextRefreshed = ContextRefreshedListener.getBean(beanFactory).get();
        if (!contextRefreshed && log.isDebugEnabled()) {
            log.debug((Object)"Context is not ready yet");
        }
        return !contextRefreshed;
    }
}

