/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.grpc;

import io.grpc.ManagedChannelBuilder;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.util.List;
import java.util.Optional;
import org.springframework.cloud.sleuth.instrument.grpc.GrpcManagedChannelBuilderCustomizer;

public class SpringAwareManagedChannelBuilder {
    private List<GrpcManagedChannelBuilderCustomizer> customizers;

    public SpringAwareManagedChannelBuilder(Optional<List<GrpcManagedChannelBuilderCustomizer>> customizers) {
        this.customizers = customizers.orElse(null);
    }

    public ManagedChannelBuilder<?> forAddress(String name, int port) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)name, (int)port);
        if (this.customizers != null) {
            this.customizers.stream().forEach(customizer -> customizer.customize(builder));
        }
        return builder;
    }

    public ManagedChannelBuilder<?> forTarget(String target) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)target);
        if (this.customizers != null) {
            this.customizers.stream().forEach(customizer -> customizer.customize(builder));
        }
        return builder;
    }

    public ManagedChannelBuilder<?> inProcessChannelBuilder(String serverName) {
        InProcessChannelBuilder builder = InProcessChannelBuilder.forName((String)serverName);
        if (this.customizers != null) {
            this.customizers.stream().forEach(arg_0 -> SpringAwareManagedChannelBuilder.lambda$inProcessChannelBuilder$2((ManagedChannelBuilder)builder, arg_0));
        }
        return builder;
    }

    private static /* synthetic */ void lambda$inProcessChannelBuilder$2(ManagedChannelBuilder builder, GrpcManagedChannelBuilderCustomizer customizer) {
        customizer.customize(builder);
    }
}

