/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.http.HttpRequest;
import brave.sampler.SamplerFunction;
import java.util.regex.Pattern;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;

class SkipPatternHttpServerSampler
implements SamplerFunction<HttpRequest> {
    private final SkipPatternProvider provider;
    private Pattern pattern;

    SkipPatternHttpServerSampler(SkipPatternProvider provider) {
        this.provider = provider;
    }

    public Boolean trySample(HttpRequest request) {
        String url = request.path();
        boolean shouldSkip = this.pattern().matcher(url).matches();
        if (shouldSkip) {
            return false;
        }
        return null;
    }

    private Pattern pattern() {
        if (this.pattern == null) {
            this.pattern = this.provider.skipPattern();
        }
        return this.pattern;
    }
}

