/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.spring.webmvc.SpanCustomizingAsyncHandlerInterceptor;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;

class TraceSpringDataBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(TraceSpringDataBeanPostProcessor.class);
    private final ApplicationContext applicationContext;

    TraceSpringDataBeanPostProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DelegatingHandlerMapping && !(bean instanceof TraceDelegatingHandlerMapping)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrapping bean [" + beanName + "] of type [" + bean.getClass().getSimpleName() + "] in its trace representation"));
            }
            return new TraceDelegatingHandlerMapping((DelegatingHandlerMapping)bean, this.applicationContext);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private static class TraceDelegatingHandlerMapping
    extends DelegatingHandlerMapping {
        private final DelegatingHandlerMapping delegate;
        private final ApplicationContext applicationContext;

        TraceDelegatingHandlerMapping(DelegatingHandlerMapping delegate, ApplicationContext beanFactory) {
            super(Collections.emptyList());
            this.delegate = delegate;
            this.applicationContext = beanFactory;
        }

        public int getOrder() {
            return this.delegate.getOrder();
        }

        public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
            HandlerExecutionChain handlerExecutionChain = this.delegate.getHandler(request);
            if (handlerExecutionChain == null) {
                return null;
            }
            handlerExecutionChain.addInterceptor((HandlerInterceptor)this.applicationContext.getBean(SpanCustomizingAsyncHandlerInterceptor.class));
            return handlerExecutionChain;
        }
    }
}

