/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

class HttpClientBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    HttpClientBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HttpClient) {
            return ((HttpClient)bean).mapConnect((BiFunction)new TracingMapConnect(this.beanFactory)).doOnRequest((BiConsumer)TracingDoOnRequest.create(this.beanFactory)).doOnRequestError((BiConsumer)TracingDoOnErrorRequest.create(this.beanFactory)).doOnResponse((BiConsumer)TracingDoOnResponse.create(this.beanFactory)).doOnResponseError((BiConsumer)TracingDoOnErrorResponse.create(this.beanFactory));
        }
        return bean;
    }

    private static class HttpAdapter
    extends HttpClientAdapter<HttpClientRequest, HttpClientResponse> {
        private HttpAdapter() {
        }

        public String method(HttpClientRequest request) {
            return request.method().name();
        }

        public String url(HttpClientRequest request) {
            return request.uri();
        }

        public String requestHeader(HttpClientRequest request, String name) {
            String result = request.requestHeaders().get(name);
            return result != null ? result.toString() : "";
        }

        public Integer statusCode(HttpClientResponse response) {
            return response.status().code();
        }
    }

    private static abstract class AbstractTracingDoOnHandler {
        final BeanFactory beanFactory;
        HttpTracing httpTracing;
        HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

        AbstractTracingDoOnHandler(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        private HttpTracing httpTracing() {
            if (this.httpTracing == null) {
                this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
            }
            return this.httpTracing;
        }

        private HttpClientHandler<HttpClientRequest, HttpClientResponse> handler() {
            if (this.handler == null) {
                this.handler = HttpClientHandler.create((HttpTracing)this.httpTracing(), (HttpClientAdapter)new HttpAdapter());
            }
            return this.handler;
        }

        protected void handle(HttpClientResponse httpClientResponse, Throwable throwable) {
            if (httpClientResponse == null) {
                return;
            }
            AtomicReference reference = (AtomicReference)httpClientResponse.currentContext().getOrDefault(AtomicReference.class, null);
            if (reference == null || reference.get() == null) {
                return;
            }
            this.handler().handleReceive((Object)httpClientResponse, throwable, (Span)reference.get());
        }
    }

    private static class TracingDoOnErrorResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientResponse, Throwable> {
        TracingDoOnErrorResponse(BeanFactory beanFactory) {
            super(beanFactory);
        }

        static TracingDoOnErrorResponse create(BeanFactory beanFactory) {
            return new TracingDoOnErrorResponse(beanFactory);
        }

        @Override
        public void accept(HttpClientResponse httpClientResponse, Throwable throwable) {
            this.handle(httpClientResponse, throwable);
        }
    }

    private static class TracingDoOnErrorRequest
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientRequest, Throwable> {
        TracingDoOnErrorRequest(BeanFactory beanFactory) {
            super(beanFactory);
        }

        static TracingDoOnErrorRequest create(BeanFactory beanFactory) {
            return new TracingDoOnErrorRequest(beanFactory);
        }

        @Override
        public void accept(HttpClientRequest request, Throwable throwable) {
            this.handle(null, throwable);
        }
    }

    private static class TracingDoOnResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientResponse, Connection> {
        TracingDoOnResponse(BeanFactory beanFactory) {
            super(beanFactory);
        }

        static TracingDoOnResponse create(BeanFactory beanFactory) {
            return new TracingDoOnResponse(beanFactory);
        }

        @Override
        public void accept(HttpClientResponse httpClientResponse, Connection connection) {
            this.handle(httpClientResponse, null);
        }
    }

    private static class TracingDoOnRequest
    implements BiConsumer<HttpClientRequest, Connection> {
        static final Propagation.Setter<HttpHeaders, String> SETTER = new Propagation.Setter<HttpHeaders, String>(){

            public void put(HttpHeaders carrier, String key, String value) {
                if (!carrier.contains(key)) {
                    carrier.add(key, (Object)value);
                }
            }

            public String toString() {
                return "HttpHeaders::add";
            }
        };
        final BeanFactory beanFactory;
        HttpTracing httpTracing;
        Tracer tracer;
        HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
        TraceContext.Injector<HttpHeaders> injector;
        Propagation<String> propagation;

        TracingDoOnRequest(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        static TracingDoOnRequest create(BeanFactory beanFactory) {
            return new TracingDoOnRequest(beanFactory);
        }

        private HttpTracing httpTracing() {
            if (this.httpTracing == null) {
                this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
            }
            return this.httpTracing;
        }

        private Propagation<String> propagation() {
            if (this.propagation == null) {
                this.propagation = this.httpTracing().tracing().propagation();
            }
            return this.propagation;
        }

        private TraceContext.Injector<HttpHeaders> injector() {
            if (this.injector == null) {
                this.injector = this.propagation().injector(SETTER);
            }
            return this.injector;
        }

        private HttpClientHandler<HttpClientRequest, HttpClientResponse> handler() {
            if (this.handler == null) {
                this.handler = HttpClientHandler.create((HttpTracing)this.httpTracing(), (HttpClientAdapter)new HttpAdapter());
            }
            return this.handler;
        }

        @Override
        public void accept(HttpClientRequest req, Connection connection) {
            if (this.propagation().keys().stream().anyMatch(key -> req.requestHeaders().contains(key))) {
                return;
            }
            AtomicReference reference = (AtomicReference)req.currentContext().getOrDefault(AtomicReference.class, new AtomicReference());
            Span span = this.handler().handleSend(this.injector(), (Object)req.requestHeaders(), (Object)req, reference.get() == null ? this.handler().nextSpan((Object)req) : (Span)reference.get());
            reference.set(span);
        }
    }

    private static class TracingMapConnect
    implements BiFunction<Mono<? extends Connection>, Bootstrap, Mono<? extends Connection>> {
        private final BeanFactory beanFactory;
        private Tracer tracer;

        TracingMapConnect(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        @Override
        public Mono<? extends Connection> apply(Mono<? extends Connection> mono, Bootstrap bootstrap) {
            return mono.subscriberContext(context -> context.put(AtomicReference.class, new AtomicReference<Span>(this.tracer().currentSpan())));
        }

        private Tracer tracer() {
            if (this.tracer == null) {
                this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
            }
            return this.tracer;
        }
    }
}

