/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import brave.Tracing;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.annotation.DefaultSpanCreator;
import org.springframework.cloud.sleuth.annotation.NewSpanParser;
import org.springframework.cloud.sleuth.annotation.NoOpTagValueResolver;
import org.springframework.cloud.sleuth.annotation.NonReactorSleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.annotation.ReactorSleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.annotation.SleuthAdvisorConfig;
import org.springframework.cloud.sleuth.annotation.SleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.annotation.SpelTagValueExpressionResolver;
import org.springframework.cloud.sleuth.annotation.TagValueExpressionResolver;
import org.springframework.cloud.sleuth.annotation.TagValueResolver;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration
@Role(value=2)
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(name={"spring.sleuth.annotation.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
public class SleuthAnnotationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    NewSpanParser newSpanParser() {
        return new DefaultSpanCreator();
    }

    @Bean
    @ConditionalOnMissingBean
    TagValueExpressionResolver spelTagValueExpressionResolver() {
        return new SpelTagValueExpressionResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    TagValueResolver noOpTagValueResolver() {
        return new NoOpTagValueResolver();
    }

    @Bean
    @Role(value=2)
    SleuthAdvisorConfig sleuthAdvisorConfig() {
        return new SleuthAdvisorConfig();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnClass(name={"reactor.core.publisher.Flux"})
    SleuthMethodInvocationProcessor reactorSleuthMethodInvocationProcessor() {
        return new ReactorSleuthMethodInvocationProcessor();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingClass(value={"reactor.core.publisher.Flux"})
    SleuthMethodInvocationProcessor nonReactorSleuthMethodInvocationProcessor() {
        return new NonReactorSleuthMethodInvocationProcessor();
    }
}

