/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.ErrorParser;
import brave.Tracing;
import brave.http.HttpClientParser;
import brave.http.HttpRequest;
import brave.http.HttpSampler;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.http.HttpTracingCustomizer;
import brave.sampler.SamplerFunction;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.instrument.web.ClientSampler;
import org.springframework.cloud.sleuth.instrument.web.CompositeHttpSampler;
import org.springframework.cloud.sleuth.instrument.web.HttpClientSampler;
import org.springframework.cloud.sleuth.instrument.web.HttpServerSampler;
import org.springframework.cloud.sleuth.instrument.web.ServerSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternHttpClientSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternHttpServerSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpClientParser;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpLegacyProperties;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpServerParser;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
@ConditionalOnBean(value={TraceWebAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.sleuth.http.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceKeys.class, SleuthHttpLegacyProperties.class})
public class TraceHttpAutoConfiguration {
    static final int TRACING_FILTER_ORDER = -2147483643;
    @Autowired(required=false)
    List<HttpTracingCustomizer> httpTracingCustomizers = new ArrayList<HttpTracingCustomizer>();

    @Bean
    @ConditionalOnMissingBean
    HttpTracing httpTracing(Tracing tracing, SkipPatternProvider provider, HttpClientParser clientParser, HttpServerParser serverParser, @HttpClientSampler SamplerFunction<HttpRequest> httpClientSampler, @Nullable @ServerSampler HttpSampler serverSampler, @Nullable @HttpServerSampler SamplerFunction<HttpRequest> httpServerSampler) {
        if (httpServerSampler == null) {
            httpServerSampler = serverSampler;
        }
        SamplerFunction<HttpRequest> combinedSampler = this.combineUserProvidedSamplerWithSkipPatternSampler((SamplerFunction<HttpRequest>)httpServerSampler, provider);
        HttpTracing.Builder builder = HttpTracing.newBuilder((Tracing)tracing).clientParser(clientParser).serverParser(serverParser).clientSampler(httpClientSampler).serverSampler(combinedSampler);
        for (HttpTracingCustomizer customizer : this.httpTracingCustomizers) {
            customizer.customize(builder);
        }
        return builder.build();
    }

    private SamplerFunction<HttpRequest> combineUserProvidedSamplerWithSkipPatternSampler(@Nullable SamplerFunction<HttpRequest> serverSampler, SkipPatternProvider provider) {
        SkipPatternHttpServerSampler skipPatternSampler = new SkipPatternHttpServerSampler(provider);
        if (serverSampler == null) {
            return skipPatternSampler;
        }
        return new CompositeHttpSampler(skipPatternSampler, serverSampler);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="true")
    HttpClientParser sleuthHttpClientParser(TraceKeys traceKeys) {
        return new SleuthHttpClientParser(traceKeys);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    HttpClientParser httpClientParser(final ErrorParser errorParser) {
        return new HttpClientParser(){

            protected ErrorParser errorParser() {
                return errorParser;
            }
        };
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="true")
    HttpServerParser sleuthHttpServerParser(TraceKeys traceKeys, ErrorParser errorParser) {
        return new SleuthHttpServerParser(traceKeys, errorParser);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    HttpServerParser defaultHttpServerParser() {
        return new HttpServerParser();
    }

    @Bean
    @ConditionalOnMissingBean(name={"sleuthHttpClientSampler"})
    SamplerFunction<HttpRequest> sleuthHttpClientSampler(@Nullable @ClientSampler HttpSampler sleuthClientSampler, SleuthWebProperties sleuthWebProperties) {
        if (sleuthClientSampler != null) {
            return sleuthClientSampler;
        }
        return new SkipPatternHttpClientSampler(sleuthWebProperties);
    }
}

