/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.util.Collections;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.web.client.RestClientException;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class TraceExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Log log = LogFactory.getLog(TraceExchangeFilterFunction.class);
    static final Propagation.Setter<ClientRequest.Builder, String> SETTER = new Propagation.Setter<ClientRequest.Builder, String>(){

        public void put(ClientRequest.Builder carrier, String key, String value) {
            carrier.headers(httpHeaders -> {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Replacing [" + key + "] with value [" + value + "]"));
                }
                httpHeaders.merge((Object)key, Collections.singletonList(value), (oldValue, newValue) -> newValue);
            });
        }

        public String toString() {
            return "ClientRequest.Builder::header";
        }
    };
    private static final String CLIENT_SPAN_KEY = "sleuth.webclient.clientSpan";
    private static final String CANCELLED_SUBSCRIPTION_ERROR = "CANCELLED";
    final BeanFactory beanFactory;
    final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
    Tracer tracer;
    HttpTracing httpTracing;
    HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler;
    TraceContext.Injector<ClientRequest.Builder> injector;

    TraceExchangeFilterFunction(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.scopePassingTransformer = ReactorSleuth.scopePassingSpanOperator(beanFactory);
    }

    public static ExchangeFilterFunction create(BeanFactory beanFactory) {
        return new TraceExchangeFilterFunction(beanFactory);
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        HttpClientRequest wrapper = new HttpClientRequest(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Instrumenting WebClient call");
        }
        Span parentSpan = this.tracer().currentSpan();
        Span span = this.handler().handleSend((brave.http.HttpClientRequest)wrapper);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handled send of " + span));
        }
        MonoWebClientTrace trace = new MonoWebClientTrace(next, wrapper.buildRequest(), this, span);
        this.tracer().withSpanInScope(parentSpan);
        return trace;
    }

    HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler() {
        if (this.handler == null) {
            this.handler = HttpClientHandler.create((HttpTracing)((HttpTracing)this.beanFactory.getBean(HttpTracing.class)));
        }
        return this.handler;
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = this.httpTracing().tracing().tracer();
        }
        return this.tracer;
    }

    HttpTracing httpTracing() {
        if (this.httpTracing == null) {
            this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
        }
        return this.httpTracing;
    }

    TraceContext.Injector<ClientRequest.Builder> injector() {
        if (this.injector == null) {
            this.injector = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().propagation().injector(SETTER);
        }
        return this.injector;
    }

    static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        private final ClientResponse delegate;

        HttpClientResponse(ClientResponse delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            try {
                return this.delegate.rawStatusCode();
            }
            catch (Exception dontCare) {
                return 0;
            }
        }
    }

    static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        private final ClientRequest delegate;
        private final ClientRequest.Builder builder;

        HttpClientRequest(ClientRequest delegate) {
            this.delegate = delegate;
            this.builder = ClientRequest.from((ClientRequest)delegate);
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return this.delegate.url().getPath();
        }

        public String url() {
            return this.delegate.url().toString();
        }

        public String header(String name) {
            return this.delegate.headers().getFirst(name);
        }

        public void header(String name, String value) {
            this.builder.header(name, new String[]{value});
        }

        ClientRequest buildRequest() {
            return this.builder.build();
        }
    }

    private static final class MonoWebClientTrace
    extends Mono<ClientResponse> {
        final ExchangeFunction next;
        final ClientRequest request;
        final Tracer tracer;
        final HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler;
        final TraceContext.Injector<ClientRequest.Builder> injector;
        final Tracing tracing;
        final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
        private final Span span;

        MonoWebClientTrace(ExchangeFunction next, ClientRequest request, TraceExchangeFilterFunction parent, Span span) {
            this.next = next;
            this.request = request;
            this.tracer = parent.tracer();
            this.handler = parent.handler();
            this.injector = parent.injector();
            this.tracing = parent.httpTracing().tracing();
            this.scopePassingTransformer = parent.scopePassingTransformer;
            this.span = span;
        }

        public void subscribe(CoreSubscriber<? super ClientResponse> subscriber) {
            Context context = subscriber.currentContext();
            this.next.exchange(this.request).subscribe((CoreSubscriber)new WebClientTracerSubscriber(subscriber, context, this.span, this));
        }

        static final class WebClientTracerSubscriber
        implements CoreSubscriber<ClientResponse> {
            final CoreSubscriber<? super ClientResponse> actual;
            final Context context;
            final Span span;
            final HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler;
            final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
            final Tracing tracing;
            boolean done;

            WebClientTracerSubscriber(CoreSubscriber<? super ClientResponse> actual, Context context, Span span, MonoWebClientTrace parent) {
                this.actual = actual;
                this.span = span;
                this.handler = parent.handler;
                this.tracing = parent.tracing;
                this.scopePassingTransformer = parent.scopePassingTransformer;
                if (!context.hasKey(Span.class)) {
                    context = context.put(Span.class, (Object)span);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Reactor Context got injected with the client span " + span));
                    }
                }
                this.context = context.put((Object)TraceExchangeFilterFunction.CLIENT_SPAN_KEY, (Object)span);
            }

            public void onSubscribe(final Subscription subscription) {
                this.actual.onSubscribe(new Subscription(){

                    public void request(long n) {
                        try (Tracer.SpanInScope ws = tracing.tracer().withSpanInScope(span);){
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Request");
                            }
                            subscription.request(n);
                        }
                    }

                    public void cancel() {
                        try (Tracer.SpanInScope ws = tracing.tracer().withSpanInScope(span);){
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Cancel");
                            }
                            this.terminateSpanOnCancel();
                            subscription.cancel();
                        }
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ClientResponse response) {
                try (Tracer.SpanInScope ws = this.tracing.tracer().withSpanInScope(this.span);){
                    this.done = true;
                    try {
                        this.actual.onNext((Object)ClientResponse.from((ClientResponse)response).body(response.bodyToFlux(DataBuffer.class).transform(this.scopePassingTransformer)).build());
                    }
                    finally {
                        this.terminateSpan(response, null);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable t) {
                try (Tracer.SpanInScope ws = this.tracing.tracer().withSpanInScope(this.span);){
                    try {
                        this.actual.onError(t);
                    }
                    finally {
                        this.terminateSpan(null, t);
                    }
                }
            }

            public void onComplete() {
                try (Tracer.SpanInScope ws = this.tracing.tracer().withSpanInScope(this.span);){
                    try {
                        this.actual.onComplete();
                    }
                    finally {
                        if (!this.done) {
                            this.terminateSpan(null, null);
                        }
                    }
                }
            }

            public Context currentContext() {
                return this.context;
            }

            void handleReceive(Span clientSpan, ClientResponse clientResponse, Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Handling receive");
                }
                this.handler.handleReceive((Object)new HttpClientResponse(clientResponse), throwable, clientSpan);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Closed scope");
                }
            }

            void terminateSpanOnCancel() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Subscription was cancelled. Will close the span [" + this.span + "]"));
                }
                this.span.tag("error", TraceExchangeFilterFunction.CANCELLED_SUBSCRIPTION_ERROR);
                this.handleReceive(this.span, null, null);
            }

            void terminateSpan(@Nullable ClientResponse clientResponse, @Nullable Throwable throwable) {
                boolean error;
                if (clientResponse == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No response was returned. Will close the span [" + this.span + "]"));
                    }
                    this.handleReceive(this.span, clientResponse, throwable);
                    return;
                }
                int statusCode = clientResponse.rawStatusCode();
                boolean bl = error = statusCode >= 400;
                if (error) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Non positive status code was returned from the call. Will close the span [" + this.span + "]"));
                    }
                    throwable = new RestClientException("Status code of the response is [" + statusCode + "]");
                }
                this.handleReceive(this.span, clientResponse, throwable);
            }
        }
    }
}

